package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryQueueStatusRequest1
 */

@JsonInclude(NON_NULL)
public class QueryQueueStatusRequest1 implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("account")
  private String account = null;

  @JsonProperty("accountType")
  private String accountType = "mi";

  @JsonProperty("acquireTrusteeship")
  private Boolean acquireTrusteeship = true;

  @JsonProperty("acquireQueueStatusInAMQ")
  private Boolean acquireQueueStatusInAMQ = false;

  @JsonProperty("acquireStock")
  private Boolean acquireStock = false;

  @JsonIgnore
  public QueryQueueStatusRequest1 head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryQueueStatusRequest1 account(String account) {
    this.account = account;
    return this;
  }

   /**
   * 账号。账号类型为el-s或el-x时，账号值传入税号。账号类型为el时，如果是单盘底账，则账号传入税号。
   * @return account
  **/


  @ApiModelProperty(value = "账号。账号类型为el-s或el-x时，账号值传入税号。账号类型为el时，如果是单盘底账，则账号传入税号。")
  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  @JsonIgnore
  public QueryQueueStatusRequest1 accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * 账号类型，mi：mi账号 un：un账号 el：el账号 el-s：底账服务器 el-x：未知的抵账类型
   * @return accountType
  **/


  @ApiModelProperty(value = "账号类型，mi：mi账号 un：un账号 el：el账号 el-s：底账服务器 el-x：未知的抵账类型")
  public String getAccountType() {
    return accountType;
  }

  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  @JsonIgnore
  public QueryQueueStatusRequest1 acquireTrusteeship(Boolean acquireTrusteeship) {
    this.acquireTrusteeship = acquireTrusteeship;
    return this;
  }

   /**
   * 是否查询托管状态,true：查询 false：不查询
   * @return acquireTrusteeship
  **/


  @ApiModelProperty(value = "是否查询托管状态,true：查询 false：不查询")
  public Boolean AcquireTrusteeship() {
    return acquireTrusteeship;
  }

  public void setAcquireTrusteeship(Boolean acquireTrusteeship) {
    this.acquireTrusteeship = acquireTrusteeship;
  }

  @JsonIgnore
  public QueryQueueStatusRequest1 acquireQueueStatusInAMQ(Boolean acquireQueueStatusInAMQ) {
    this.acquireQueueStatusInAMQ = acquireQueueStatusInAMQ;
    return this;
  }

   /**
   * 是否查询队列在AMQ中在线标志(仅账号类型=mi账号时有效),true：查询 false：不查询
   * @return acquireQueueStatusInAMQ
  **/


  @ApiModelProperty(value = "是否查询队列在AMQ中在线标志(仅账号类型=mi账号时有效),true：查询 false：不查询")
  public Boolean AcquireQueueStatusInAMQ() {
    return acquireQueueStatusInAMQ;
  }

  public void setAcquireQueueStatusInAMQ(Boolean acquireQueueStatusInAMQ) {
    this.acquireQueueStatusInAMQ = acquireQueueStatusInAMQ;
  }

  @JsonIgnore
  public QueryQueueStatusRequest1 acquireStock(Boolean acquireStock) {
    this.acquireStock = acquireStock;
    return this;
  }

   /**
   * 是否查询库存(仅账号类型=mi账号时有效),true：查询 false：不查询
   * @return acquireStock
  **/


  @ApiModelProperty(value = "是否查询库存(仅账号类型=mi账号时有效),true：查询 false：不查询")
  public Boolean AcquireStock() {
    return acquireStock;
  }

  public void setAcquireStock(Boolean acquireStock) {
    this.acquireStock = acquireStock;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryQueueStatusRequest1 queryQueueStatusRequest1 = (QueryQueueStatusRequest1) o;
    return Objects.equals(this.head, queryQueueStatusRequest1.head) &&
        Objects.equals(this.account, queryQueueStatusRequest1.account) &&
        Objects.equals(this.accountType, queryQueueStatusRequest1.accountType) &&
        Objects.equals(this.acquireTrusteeship, queryQueueStatusRequest1.acquireTrusteeship) &&
        Objects.equals(this.acquireQueueStatusInAMQ, queryQueueStatusRequest1.acquireQueueStatusInAMQ) &&
        Objects.equals(this.acquireStock, queryQueueStatusRequest1.acquireStock);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, account, accountType, acquireTrusteeship, acquireQueueStatusInAMQ, acquireStock);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryQueueStatusRequest1 {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    acquireTrusteeship: ").append(toIndentedString(acquireTrusteeship)).append("\n");
    sb.append("    acquireQueueStatusInAMQ: ").append(toIndentedString(acquireQueueStatusInAMQ)).append("\n");
    sb.append("    acquireStock: ").append(toIndentedString(acquireStock)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
