package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.ResponsePageInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryResponseInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryTerminalResponse
 */

@JsonInclude(NON_NULL)
public class QueryTerminalResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("terminals")
  private List<TerminalQueryResponseInfo> terminals = new ArrayList<>();

  @JsonProperty("pageInfo")
  private ResponsePageInfo pageInfo = null;

  @JsonIgnore
  public QueryTerminalResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 终端信息获取响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "终端信息获取响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryTerminalResponse terminals(List<TerminalQueryResponseInfo> terminals) {
    this.terminals = terminals;
    return this;
  }

  public QueryTerminalResponse addTerminalsItem(TerminalQueryResponseInfo terminalsItem) {
    this.terminals.add(terminalsItem);
    return this;
  }

   /**
   * 终端列表
   * @return terminals
  **/

  @Valid

  @ApiModelProperty(value = "终端列表")
  public List<TerminalQueryResponseInfo> getTerminals() {
    return terminals;
  }

  public void setTerminals(List<TerminalQueryResponseInfo> terminals) {
    this.terminals = terminals;
  }

  @JsonIgnore
  public QueryTerminalResponse pageInfo(ResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/

  @Valid

  @ApiModelProperty(value = "分页信息")
  public ResponsePageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(ResponsePageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryTerminalResponse queryTerminalResponse = (QueryTerminalResponse) o;
    return Objects.equals(this.head, queryTerminalResponse.head) &&
        Objects.equals(this.terminals, queryTerminalResponse.terminals) &&
        Objects.equals(this.pageInfo, queryTerminalResponse.pageInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminals, pageInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryTerminalResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminals: ").append(toIndentedString(terminals)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
