package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RemoveMonitoredQueueRequest
 */

@JsonInclude(NON_NULL)
public class RemoveMonitoredQueueRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("miList")
  private List<String> miList = new ArrayList<>();

  @JsonIgnore
  public RemoveMonitoredQueueRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RemoveMonitoredQueueRequest miList(List<String> miList) {
    this.miList = miList;
    return this;
  }

  public RemoveMonitoredQueueRequest addMiListItem(String miListItem) {
    this.miList.add(miListItem);
    return this;
  }

   /**
   * mi名称
   * @return miList
  **/


  @ApiModelProperty(value = "mi名称")
  public List<String> getMiList() {
    return miList;
  }

  public void setMiList(List<String> miList) {
    this.miList = miList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RemoveMonitoredQueueRequest removeMonitoredQueueRequest = (RemoveMonitoredQueueRequest) o;
    return Objects.equals(this.head, removeMonitoredQueueRequest.head) &&
        Objects.equals(this.miList, removeMonitoredQueueRequest.miList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, miList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RemoveMonitoredQueueRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    miList: ").append(toIndentedString(miList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
