package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.OriginAccountTerminalInfo;
import com.xforceplus.micro.tax.device.contract.model.StockInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class TerminalQueryResponseInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("unionId")
  private String unionId = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("companyInfo")
  private CompanyInfo companyInfo = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("terminalTypeMode")
  private Integer terminalTypeMode = 0;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<>();

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("paddingLeft")
  private Integer paddingLeft = null;

  @JsonProperty("paddingTop")
  private Integer paddingTop = null;

  @JsonProperty("printInvoiceTerminalId")
  private Long printInvoiceTerminalId = null;

  @JsonProperty("printSaleListTerminalId")
  private Long printSaleListTerminalId = null;

  @JsonProperty("printerOnlineFlag")
  private Boolean printerOnlineFlag = null;

  @JsonProperty("directOnlineFlag")
  private Boolean directOnlineFlag = null;

  @JsonProperty("hasLicenseFlag")
  private Boolean hasLicenseFlag = null;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("uKeySupportFlag")
  private Integer uKeySupportFlag = null;

  @JsonProperty("customExtra")
  private String customExtra = null;

  @JsonProperty("email")
  private String email = null;

  @JsonProperty("phone")
  private String phone = null;

  @JsonProperty("key")
  private String key = null;

  @JsonProperty("keyExpireAt")
  private String keyExpireAt = null;

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonProperty("originAccountInfo")
  private OriginAccountTerminalInfo originAccountInfo = null;

  @JsonProperty("onlineDevices")
  private List<DeviceInfo> onlineDevices = new ArrayList<>();

  @JsonProperty("stockInfo")
  private StockInfo stockInfo = null;

  @JsonIgnore
  public TerminalQueryResponseInfo id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 终端id（已废弃，用terminalUn代替）
   * @return id
  **/


  @ApiModelProperty(value = "终端id（已废弃，用terminalUn代替）")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo unionId(String unionId) {
    this.unionId = unionId;
    return this;
  }

   /**
   * 终端unionId（已废弃，用terminalUn代替）
   * @return unionId
  **/


  @ApiModelProperty(value = "终端unionId（已废弃，用terminalUn代替）")
  public String getUnionId() {
    return unionId;
  }

  public void setUnionId(String unionId) {
    this.unionId = unionId;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * 终端唯一码
   * @return terminalUn
  **/


  @ApiModelProperty(value = "终端唯一码")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id，服务器终端时返回（已废弃，用deviceUn代替）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id，服务器终端时返回（已废弃，用deviceUn代替）")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码，服务器终端时返回
   * @return deviceUn
  **/


  @ApiModelProperty(value = "设备唯一码，服务器终端时返回")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo companyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/

  @Valid

  @ApiModelProperty(value = "公司信息")
  public CompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端编号
   * @return terminalNo
  **/


  @ApiModelProperty(value = "终端编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/


  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo terminalType(Integer terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * 终端类型 1：单盘 2：服务器  3:底账服务器  4:区块链终端 5:VUKey终端
   * @return terminalType
  **/


  @ApiModelProperty(value = "终端类型 1：单盘 2：服务器  3:底账服务器  4:区块链终端 5:VUKey终端")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo terminalTypeMode(Integer terminalTypeMode) {
    this.terminalTypeMode = terminalTypeMode;
    return this;
  }

   /**
   * 终端类型模式，终端类型为1时，0：表示发票助手（默认） 1：表示百望云
   * @return terminalTypeMode
  **/


  @ApiModelProperty(value = "终端类型模式，终端类型为1时，0：表示发票助手（默认） 1：表示百望云")
  public Integer getTerminalTypeMode() {
    return terminalTypeMode;
  }

  public void setTerminalTypeMode(Integer terminalTypeMode) {
    this.terminalTypeMode = terminalTypeMode;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public TerminalQueryResponseInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public TerminalQueryResponseInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）
   * @return supportService
  **/


  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 22：作废）
   * @return status
  **/


  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo paddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
    return this;
  }

   /**
   * 左边距
   * @return paddingLeft
  **/


  @ApiModelProperty(value = "左边距")
  public Integer getPaddingLeft() {
    return paddingLeft;
  }

  public void setPaddingLeft(Integer paddingLeft) {
    this.paddingLeft = paddingLeft;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo paddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
    return this;
  }

   /**
   * 上边距
   * @return paddingTop
  **/


  @ApiModelProperty(value = "上边距")
  public Integer getPaddingTop() {
    return paddingTop;
  }

  public void setPaddingTop(Integer paddingTop) {
    this.paddingTop = paddingTop;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo printInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
    return this;
  }

   /**
   * 打印发票终端id
   * @return printInvoiceTerminalId
  **/


  @ApiModelProperty(value = "打印发票终端id")
  public Long getPrintInvoiceTerminalId() {
    return printInvoiceTerminalId;
  }

  public void setPrintInvoiceTerminalId(Long printInvoiceTerminalId) {
    this.printInvoiceTerminalId = printInvoiceTerminalId;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo printSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
    return this;
  }

   /**
   * 打印销货清单终端id
   * @return printSaleListTerminalId
  **/


  @ApiModelProperty(value = "打印销货清单终端id")
  public Long getPrintSaleListTerminalId() {
    return printSaleListTerminalId;
  }

  public void setPrintSaleListTerminalId(Long printSaleListTerminalId) {
    this.printSaleListTerminalId = printSaleListTerminalId;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo printerOnlineFlag(Boolean printerOnlineFlag) {
    this.printerOnlineFlag = printerOnlineFlag;
    return this;
  }

   /**
   * 打印功能是否在线
   * @return printerOnlineFlag
  **/


  @ApiModelProperty(value = "打印功能是否在线")
  public Boolean PrinterOnlineFlag() {
    return printerOnlineFlag;
  }

  public void setPrinterOnlineFlag(Boolean printerOnlineFlag) {
    this.printerOnlineFlag = printerOnlineFlag;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo directOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
    return this;
  }

   /**
   * 直连功能是否在线
   * @return directOnlineFlag
  **/


  @ApiModelProperty(value = "直连功能是否在线")
  public Boolean DirectOnlineFlag() {
    return directOnlineFlag;
  }

  public void setDirectOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo hasLicenseFlag(Boolean hasLicenseFlag) {
    this.hasLicenseFlag = hasLicenseFlag;
    return this;
  }

   /**
   * 是否有授权文件
   * @return hasLicenseFlag
  **/


  @ApiModelProperty(value = "是否有授权文件")
  public Boolean HasLicenseFlag() {
    return hasLicenseFlag;
  }

  public void setHasLicenseFlag(Boolean hasLicenseFlag) {
    this.hasLicenseFlag = hasLicenseFlag;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * 打印终端监听的队列，查询时返回
   * @return queueName
  **/


  @ApiModelProperty(value = "打印终端监听的队列，查询时返回")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo uKeySupportFlag(Integer uKeySupportFlag) {
    this.uKeySupportFlag = uKeySupportFlag;
    return this;
  }

   /**
   * ukey支持标志，0-不支持 1-支持
   * @return uKeySupportFlag
  **/


  @ApiModelProperty(value = "ukey支持标志，0-不支持 1-支持")
  public Integer getUKeySupportFlag() {
    return uKeySupportFlag;
  }

  public void setUKeySupportFlag(Integer uKeySupportFlag) {
    this.uKeySupportFlag = uKeySupportFlag;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo customExtra(String customExtra) {
    this.customExtra = customExtra;
    return this;
  }

   /**
   * 自定义额外参数
   * @return customExtra
  **/


  @ApiModelProperty(value = "自定义额外参数")
  public String getCustomExtra() {
    return customExtra;
  }

  public void setCustomExtra(String customExtra) {
    this.customExtra = customExtra;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo email(String email) {
    this.email = email;
    return this;
  }

   /**
   * 邮箱，用于接收终端激活码
   * @return email
  **/


  @ApiModelProperty(value = "邮箱，用于接收终端激活码")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo phone(String phone) {
    this.phone = phone;
    return this;
  }

   /**
   * 手机，用于接收终端激活码
   * @return phone
  **/


  @ApiModelProperty(value = "手机，用于接收终端激活码")
  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo key(String key) {
    this.key = key;
    return this;
  }

   /**
   * 终端激活码
   * @return key
  **/


  @ApiModelProperty(value = "终端激活码")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo keyExpireAt(String keyExpireAt) {
    this.keyExpireAt = keyExpireAt;
    return this;
  }

   /**
   * 激活码有效期
   * @return keyExpireAt
  **/


  @ApiModelProperty(value = "激活码有效期")
  public String getKeyExpireAt() {
    return keyExpireAt;
  }

  public void setKeyExpireAt(String keyExpireAt) {
    this.keyExpireAt = keyExpireAt;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/


  @ApiModelProperty(value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo originAccountInfo(OriginAccountTerminalInfo originAccountInfo) {
    this.originAccountInfo = originAccountInfo;
    return this;
  }

   /**
   * 底账服务器终端信息
   * @return originAccountInfo
  **/

  @Valid

  @ApiModelProperty(value = "底账服务器终端信息")
  public OriginAccountTerminalInfo getOriginAccountInfo() {
    return originAccountInfo;
  }

  public void setOriginAccountInfo(OriginAccountTerminalInfo originAccountInfo) {
    this.originAccountInfo = originAccountInfo;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo onlineDevices(List<DeviceInfo> onlineDevices) {
    this.onlineDevices = onlineDevices;
    return this;
  }

  public TerminalQueryResponseInfo addOnlineDevicesItem(DeviceInfo onlineDevicesItem) {
    this.onlineDevices.add(onlineDevicesItem);
    return this;
  }

   /**
   * 在线的设备,非空
   * @return onlineDevices
  **/

  @Valid

  @ApiModelProperty(value = "在线的设备,非空")
  public List<DeviceInfo> getOnlineDevices() {
    return onlineDevices;
  }

  public void setOnlineDevices(List<DeviceInfo> onlineDevices) {
    this.onlineDevices = onlineDevices;
  }

  @JsonIgnore
  public TerminalQueryResponseInfo stockInfo(StockInfo stockInfo) {
    this.stockInfo = stockInfo;
    return this;
  }

   /**
   * 库存信息
   * @return stockInfo
  **/

  @Valid

  @ApiModelProperty(value = "库存信息")
  public StockInfo getStockInfo() {
    return stockInfo;
  }

  public void setStockInfo(StockInfo stockInfo) {
    this.stockInfo = stockInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalQueryResponseInfo terminalQueryResponseInfo = (TerminalQueryResponseInfo) o;
    return Objects.equals(this.id, terminalQueryResponseInfo.id) &&
        Objects.equals(this.unionId, terminalQueryResponseInfo.unionId) &&
        Objects.equals(this.terminalUn, terminalQueryResponseInfo.terminalUn) &&
        Objects.equals(this.deviceId, terminalQueryResponseInfo.deviceId) &&
        Objects.equals(this.deviceUn, terminalQueryResponseInfo.deviceUn) &&
        Objects.equals(this.companyInfo, terminalQueryResponseInfo.companyInfo) &&
        Objects.equals(this.operateInfo, terminalQueryResponseInfo.operateInfo) &&
        Objects.equals(this.terminalNo, terminalQueryResponseInfo.terminalNo) &&
        Objects.equals(this.terminalName, terminalQueryResponseInfo.terminalName) &&
        Objects.equals(this.terminalType, terminalQueryResponseInfo.terminalType) &&
        Objects.equals(this.terminalTypeMode, terminalQueryResponseInfo.terminalTypeMode) &&
        Objects.equals(this.invoiceType, terminalQueryResponseInfo.invoiceType) &&
        Objects.equals(this.supportService, terminalQueryResponseInfo.supportService) &&
        Objects.equals(this.status, terminalQueryResponseInfo.status) &&
        Objects.equals(this.paddingLeft, terminalQueryResponseInfo.paddingLeft) &&
        Objects.equals(this.paddingTop, terminalQueryResponseInfo.paddingTop) &&
        Objects.equals(this.printInvoiceTerminalId, terminalQueryResponseInfo.printInvoiceTerminalId) &&
        Objects.equals(this.printSaleListTerminalId, terminalQueryResponseInfo.printSaleListTerminalId) &&
        Objects.equals(this.printerOnlineFlag, terminalQueryResponseInfo.printerOnlineFlag) &&
        Objects.equals(this.directOnlineFlag, terminalQueryResponseInfo.directOnlineFlag) &&
        Objects.equals(this.hasLicenseFlag, terminalQueryResponseInfo.hasLicenseFlag) &&
        Objects.equals(this.queueName, terminalQueryResponseInfo.queueName) &&
        Objects.equals(this.uKeySupportFlag, terminalQueryResponseInfo.uKeySupportFlag) &&
        Objects.equals(this.customExtra, terminalQueryResponseInfo.customExtra) &&
        Objects.equals(this.email, terminalQueryResponseInfo.email) &&
        Objects.equals(this.phone, terminalQueryResponseInfo.phone) &&
        Objects.equals(this.key, terminalQueryResponseInfo.key) &&
        Objects.equals(this.keyExpireAt, terminalQueryResponseInfo.keyExpireAt) &&
        Objects.equals(this.fromSystem, terminalQueryResponseInfo.fromSystem) &&
        Objects.equals(this.originAccountInfo, terminalQueryResponseInfo.originAccountInfo) &&
        Objects.equals(this.onlineDevices, terminalQueryResponseInfo.onlineDevices) &&
        Objects.equals(this.stockInfo, terminalQueryResponseInfo.stockInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, unionId, terminalUn, deviceId, deviceUn, companyInfo, operateInfo, terminalNo, terminalName, terminalType, terminalTypeMode, invoiceType, supportService, status, paddingLeft, paddingTop, printInvoiceTerminalId, printSaleListTerminalId, printerOnlineFlag, directOnlineFlag, hasLicenseFlag, queueName, uKeySupportFlag, customExtra, email, phone, key, keyExpireAt, fromSystem, originAccountInfo, onlineDevices, stockInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalQueryResponseInfo {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    unionId: ").append(toIndentedString(unionId)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    terminalTypeMode: ").append(toIndentedString(terminalTypeMode)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    paddingLeft: ").append(toIndentedString(paddingLeft)).append("\n");
    sb.append("    paddingTop: ").append(toIndentedString(paddingTop)).append("\n");
    sb.append("    printInvoiceTerminalId: ").append(toIndentedString(printInvoiceTerminalId)).append("\n");
    sb.append("    printSaleListTerminalId: ").append(toIndentedString(printSaleListTerminalId)).append("\n");
    sb.append("    printerOnlineFlag: ").append(toIndentedString(printerOnlineFlag)).append("\n");
    sb.append("    directOnlineFlag: ").append(toIndentedString(directOnlineFlag)).append("\n");
    sb.append("    hasLicenseFlag: ").append(toIndentedString(hasLicenseFlag)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    uKeySupportFlag: ").append(toIndentedString(uKeySupportFlag)).append("\n");
    sb.append("    customExtra: ").append(toIndentedString(customExtra)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    keyExpireAt: ").append(toIndentedString(keyExpireAt)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("    originAccountInfo: ").append(toIndentedString(originAccountInfo)).append("\n");
    sb.append("    onlineDevices: ").append(toIndentedString(onlineDevices)).append("\n");
    sb.append("    stockInfo: ").append(toIndentedString(stockInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
