package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * CA资质查询消息
 *
 * @author Bobo
 * @create 2020/9/3 16:50
 * @since 1.0.0
 */
public class CAQualificationsMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private CAQualificationsMessage.Response.Result result = new CAQualificationsMessage.Response.Result();

        @Data
        public static class Result {

            private List<CAQualificationsMessage.Response.Qualification> qualificationList;

        }

        @Data
        public static class Qualification {

            /**
             * 税号
             */
            private String taxCode;

            /**
             * CA状态
             * unsubmit：未提交申请 valid：有效的 invalid：无效的 auditing：审核中
             */
            private String caStatus;

            /**
             * CA证书到期日 格式：yyyyMMddHHmmssSSS
             */
            private String caExpireAt;

        }

    }

}
