package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 设备库存消息
 *
 * @author Bobo
 * @create 2020/8/4 16:53
 * @since 1.0.0
 */
public class DeviceInventoryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceInventoryMessage.Result result = new DeviceInventoryMessage.Result();
    }

    @Data
    public static class Result {

        private List<DeviceInventoryDto> deviceInventoryList;

    }

    @Data
    public static class DeviceInventoryDto {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 剩余库存份数
         */
        private Integer inventoryNum;

        /**
         * 库存明细
         */
        private List<InventoryDetailDto> inventoryDetails;

    }

    @Data
    public static class InventoryDetailDto {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 起始号码
         */
        private String startInvoiceNo;

        /**
         * 终止号码
         */
        private String endInvoiceNo;

        /**
         * 领购份数
         */
        private Integer purchaseNum;

        /**
         * 剩余份数
         */
        private Integer inventoryNum;

        /**
         * 领购日期（yyyyMMdd）
         */
        private String purchaseDate;

        /**
         * 领购人员
         */
        private String purchaseName;

    }
}
