package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 查询设备上成品油发票开具资质 消息
 *
 * @author Bobo
 * @create 2020/8/21 15:54
 * @since 1.0.0
 */
public class RefinedOilsQualificationsMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private RefinedOilsQualificationsMessage.Response.Result result = new RefinedOilsQualificationsMessage.Response.Result();

        @Data
        public static class Result {

            private List<RefinedOilsQualificationsMessage.Response.Qualification> qualificationList;

        }

        @Data
        public static class Qualification {

            /**
             * 税号
             */
            private String taxCode;

            /**
             * 设备编号
             */
            private String deviceNo;

            /**
             * 设备唯一码
             */
            private String deviceUn;

            /**
             * 成品油企业有效期起始时间(yyyy-MM-dd)
             */
            private String oilStartTime;

            /**
             * 成品油企业有效期截止时间(yyyy-MM-dd)
             */
            private String oilEndTime;

        }

    }
}
