package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 税控服务器信息查询消息
 *
 * @author Bobo
 * @create 2020/8/21 15:08
 * @since 1.0.0
 */
public class TaxControlQueryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private TaxControlQueryMessage.Response.Result result = new TaxControlQueryMessage.Response.Result();

        @Data
        public static class Result {

            private List<TaxControlQueryMessage.Response.TaxControlServer> taxControlServers;

        }

        @Data
        public static class TaxControlServer {

            /**
             * 税号
             */
            private String taxCode;

            /**
             * 税控服务器地址
             */
            private String serverUrl;

            /**
             * 通道类型
             */
            private String channel;

            /**
             * 是否具有CA资质
             */
            private Boolean caQualification;

            /**
             * 扩展字段
             */
            private String ext;

        }

    }

}
