package com.xforceplus.micro.tax.device.contract.model.vatv2;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.device.contract.model.vatv2.model.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 开票虚拟设备信息
 *
 * @author zhouwen
 * @date 2020-04-06
 */
public class VUKeyDeviceMessage {

    @Data
    public static class Request {

        /**
         * 税号
         */
        private List<String> taxCodes;

        /**
         * 设备唯一码
         */
        private String deviceUn;

        /**
         * 设备编号
         */
        private String deviceNo;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            private List<DeviceDto> deviceList;
        }
    }
}
