package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AddMonitoredQueueRequest
 */

@JsonInclude(NON_NULL)
public class AddMonitoredQueueRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("miList")
  private List<String> miList = new ArrayList<>();

  @JsonIgnore
  public AddMonitoredQueueRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AddMonitoredQueueRequest miList(List<String> miList) {
    this.miList = miList;
    return this;
  }

  public AddMonitoredQueueRequest addMiListItem(String miListItem) {
    this.miList.add(miListItem);
    return this;
  }

   /**
   * MI列表
   * @return miList
  **/


  @ApiModelProperty(value = "MI列表")
  public List<String> getMiList() {
    return miList;
  }

  public void setMiList(List<String> miList) {
    this.miList = miList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddMonitoredQueueRequest addMonitoredQueueRequest = (AddMonitoredQueueRequest) o;
    return Objects.equals(this.head, addMonitoredQueueRequest.head) &&
        Objects.equals(this.miList, addMonitoredQueueRequest.miList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, miList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddMonitoredQueueRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    miList: ").append(toIndentedString(miList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
