package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ClientInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * BindLicenseRequest
 */

@JsonInclude(NON_NULL)
public class BindLicenseRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("clientInfo")
  private ClientInfo clientInfo = null;

  @JsonProperty("licenseNo")
  private String licenseNo = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonIgnore
  public BindLicenseRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public BindLicenseRequest clientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * 客户端信息
   * @return clientInfo
  **/

  @Valid

  @ApiModelProperty(value = "客户端信息")
  public ClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(ClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  @JsonIgnore
  public BindLicenseRequest licenseNo(String licenseNo) {
    this.licenseNo = licenseNo;
    return this;
  }

   /**
   * 授权文件编号
   * @return licenseNo
  **/


  @ApiModelProperty(value = "授权文件编号")
  public String getLicenseNo() {
    return licenseNo;
  }

  public void setLicenseNo(String licenseNo) {
    this.licenseNo = licenseNo;
  }

  @JsonIgnore
  public BindLicenseRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BindLicenseRequest bindLicenseRequest = (BindLicenseRequest) o;
    return Objects.equals(this.head, bindLicenseRequest.head) &&
        Objects.equals(this.clientInfo, bindLicenseRequest.clientInfo) &&
        Objects.equals(this.licenseNo, bindLicenseRequest.licenseNo) &&
        Objects.equals(this.operateInfo, bindLicenseRequest.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, clientInfo, licenseNo, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BindLicenseRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("    licenseNo: ").append(toIndentedString(licenseNo)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
