package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.TerminalInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * BindLicenseResponse
 */

@JsonInclude(NON_NULL)
public class BindLicenseResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("terminalInfo")
  private TerminalInfo terminalInfo = null;

  @JsonProperty("deviceInfo")
  private List<DeviceInfo> deviceInfo = new ArrayList<>();

  @JsonIgnore
  public BindLicenseResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 授权文件绑定响应，客户端调用时subCode=119 表示加密校验失败
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "授权文件绑定响应，客户端调用时subCode=119 表示加密校验失败")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public BindLicenseResponse terminalInfo(TerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息 当授权文件为终端授权文件时返回
   * @return terminalInfo
  **/

  @Valid

  @ApiModelProperty(value = "终端信息 当授权文件为终端授权文件时返回")
  public TerminalInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(TerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }

  @JsonIgnore
  public BindLicenseResponse deviceInfo(List<DeviceInfo> deviceInfo) {
    this.deviceInfo = deviceInfo;
    return this;
  }

  public BindLicenseResponse addDeviceInfoItem(DeviceInfo deviceInfoItem) {
    this.deviceInfo.add(deviceInfoItem);
    return this;
  }

   /**
   * 设备信息 当授权文件为设备授权文件时返回或者授权文件为底账服务器终端时返回
   * @return deviceInfo
  **/

  @Valid

  @ApiModelProperty(value = "设备信息 当授权文件为设备授权文件时返回或者授权文件为底账服务器终端时返回")
  public List<DeviceInfo> getDeviceInfo() {
    return deviceInfo;
  }

  public void setDeviceInfo(List<DeviceInfo> deviceInfo) {
    this.deviceInfo = deviceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BindLicenseResponse bindLicenseResponse = (BindLicenseResponse) o;
    return Objects.equals(this.head, bindLicenseResponse.head) &&
        Objects.equals(this.terminalInfo, bindLicenseResponse.terminalInfo) &&
        Objects.equals(this.deviceInfo, bindLicenseResponse.deviceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalInfo, deviceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BindLicenseResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("    deviceInfo: ").append(toIndentedString(deviceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
