package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ClientLoginInfoRequest
 */

@JsonInclude(NON_NULL)
public class ClientLoginInfoRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("cid")
  private String cid = null;

  @JsonProperty("account")
  private String account = null;

  @JsonProperty("account_type")
  private String accountType = null;

  @JsonProperty("clientVersion")
  private String clientVersion = null;

  @JsonProperty("nextVersion")
  private String nextVersion = null;

  @JsonProperty("updateType")
  private String updateType = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("machineNo")
  private String machineNo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonIgnore
  public ClientLoginInfoRequest cid(String cid) {
    this.cid = cid;
    return this;
  }

   /**
   * CID
   * @return cid
  **/


  @ApiModelProperty(value = "CID")
  public String getCid() {
    return cid;
  }

  public void setCid(String cid) {
    this.cid = cid;
  }

  @JsonIgnore
  public ClientLoginInfoRequest account(String account) {
    this.account = account;
    return this;
  }

   /**
   * 账号
   * @return account
  **/


  @ApiModelProperty(value = "账号")
  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  @JsonIgnore
  public ClientLoginInfoRequest accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * 税号
   * @return accountType
  **/


  @ApiModelProperty(value = "税号")
  public String getAccountType() {
    return accountType;
  }

  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  @JsonIgnore
  public ClientLoginInfoRequest clientVersion(String clientVersion) {
    this.clientVersion = clientVersion;
    return this;
  }

   /**
   * 当前客户端版本
   * @return clientVersion
  **/


  @ApiModelProperty(value = "当前客户端版本")
  public String getClientVersion() {
    return clientVersion;
  }

  public void setClientVersion(String clientVersion) {
    this.clientVersion = clientVersion;
  }

  @JsonIgnore
  public ClientLoginInfoRequest nextVersion(String nextVersion) {
    this.nextVersion = nextVersion;
    return this;
  }

   /**
   * 客户端可升级版本
   * @return nextVersion
  **/


  @ApiModelProperty(value = "客户端可升级版本")
  public String getNextVersion() {
    return nextVersion;
  }

  public void setNextVersion(String nextVersion) {
    this.nextVersion = nextVersion;
  }

  @JsonIgnore
  public ClientLoginInfoRequest updateType(String updateType) {
    this.updateType = updateType;
    return this;
  }

   /**
   * 升级类型 【0-静默 1-强制弹窗】
   * @return updateType
  **/


  @ApiModelProperty(value = "升级类型 【0-静默 1-强制弹窗】")
  public String getUpdateType() {
    return updateType;
  }

  public void setUpdateType(String updateType) {
    this.updateType = updateType;
  }

  @JsonIgnore
  public ClientLoginInfoRequest tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 租户名称
   * @return tenantName
  **/


  @ApiModelProperty(value = "租户名称")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public ClientLoginInfoRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 租户代码
   * @return tenantCode
  **/


  @ApiModelProperty(value = "租户代码")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public ClientLoginInfoRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/


  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public ClientLoginInfoRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号
   * @return taxNo
  **/


  @ApiModelProperty(value = "税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public ClientLoginInfoRequest machineNo(String machineNo) {
    this.machineNo = machineNo;
    return this;
  }

   /**
   * 开票机号
   * @return machineNo
  **/


  @ApiModelProperty(value = "开票机号")
  public String getMachineNo() {
    return machineNo;
  }

  public void setMachineNo(String machineNo) {
    this.machineNo = machineNo;
  }

  @JsonIgnore
  public ClientLoginInfoRequest deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 盘号
   * @return deviceNo
  **/


  @ApiModelProperty(value = "盘号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientLoginInfoRequest clientLoginInfoRequest = (ClientLoginInfoRequest) o;
    return Objects.equals(this.cid, clientLoginInfoRequest.cid) &&
        Objects.equals(this.account, clientLoginInfoRequest.account) &&
        Objects.equals(this.accountType, clientLoginInfoRequest.accountType) &&
        Objects.equals(this.clientVersion, clientLoginInfoRequest.clientVersion) &&
        Objects.equals(this.nextVersion, clientLoginInfoRequest.nextVersion) &&
        Objects.equals(this.updateType, clientLoginInfoRequest.updateType) &&
        Objects.equals(this.tenantName, clientLoginInfoRequest.tenantName) &&
        Objects.equals(this.tenantCode, clientLoginInfoRequest.tenantCode) &&
        Objects.equals(this.companyName, clientLoginInfoRequest.companyName) &&
        Objects.equals(this.taxNo, clientLoginInfoRequest.taxNo) &&
        Objects.equals(this.machineNo, clientLoginInfoRequest.machineNo) &&
        Objects.equals(this.deviceNo, clientLoginInfoRequest.deviceNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cid, account, accountType, clientVersion, nextVersion, updateType, tenantName, tenantCode, companyName, taxNo, machineNo, deviceNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientLoginInfoRequest {\n");
    
    sb.append("    cid: ").append(toIndentedString(cid)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    clientVersion: ").append(toIndentedString(clientVersion)).append("\n");
    sb.append("    nextVersion: ").append(toIndentedString(nextVersion)).append("\n");
    sb.append("    updateType: ").append(toIndentedString(updateType)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    machineNo: ").append(toIndentedString(machineNo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
