package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ClientStockRequest
 */

@JsonInclude(NON_NULL)
public class ClientStockRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("properties")
  private String properties = null;

  @JsonProperty("body")
  private String body = null;

  @JsonIgnore
  public ClientStockRequest properties(String properties) {
    this.properties = properties;
    return this;
  }

   /**
   * 消息头
   * @return properties
  **/


  @ApiModelProperty(value = "消息头")
  public String getProperties() {
    return properties;
  }

  public void setProperties(String properties) {
    this.properties = properties;
  }

  @JsonIgnore
  public ClientStockRequest body(String body) {
    this.body = body;
    return this;
  }

   /**
   * 消息体
   * @return body
  **/


  @ApiModelProperty(value = "消息体")
  public String getBody() {
    return body;
  }

  public void setBody(String body) {
    this.body = body;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ClientStockRequest clientStockRequest = (ClientStockRequest) o;
    return Objects.equals(this.properties, clientStockRequest.properties) &&
        Objects.equals(this.body, clientStockRequest.body);
  }

  @Override
  public int hashCode() {
    return Objects.hash(properties, body);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ClientStockRequest {\n");
    
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
