package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 公司注册信息
 */
@ApiModel(description = "公司注册信息")

@JsonInclude(NON_NULL)
public class CompanyRegisterInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("groupCode")
  private String groupCode = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("operationType")
  private String operationType = null;

  @JsonProperty("usageModel")
  private String usageModel = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("companyAddress")
  private String companyAddress = null;

  @JsonProperty("companyTel")
  private String companyTel = null;

  @JsonProperty("province")
  private String province = null;

  @JsonProperty("city")
  private String city = null;

  @JsonProperty("contactorName")
  private String contactorName = null;

  @JsonProperty("contactorTel")
  private String contactorTel = null;

  @JsonProperty("contactorId")
  private String contactorId = null;

  @JsonProperty("businessLicense")
  private String businessLicense = null;

  @JsonProperty("application")
  private String application = null;

  @JsonProperty("idFront")
  private String idFront = null;

  @JsonProperty("idBack")
  private String idBack = null;

  @JsonIgnore
  public CompanyRegisterInfo requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public CompanyRegisterInfo groupCode(String groupCode) {
    this.groupCode = groupCode;
    return this;
  }

   /**
   * 分组标志
   * @return groupCode
  **/


  @ApiModelProperty(value = "分组标志")
  public String getGroupCode() {
    return groupCode;
  }

  public void setGroupCode(String groupCode) {
    this.groupCode = groupCode;
  }

  @JsonIgnore
  public CompanyRegisterInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/


  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public CompanyRegisterInfo companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/


  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public CompanyRegisterInfo operationType(String operationType) {
    this.operationType = operationType;
    return this;
  }

   /**
   * 操作类型
   * @return operationType
  **/


  @ApiModelProperty(value = "操作类型")
  public String getOperationType() {
    return operationType;
  }

  public void setOperationType(String operationType) {
    this.operationType = operationType;
  }

  @JsonIgnore
  public CompanyRegisterInfo usageModel(String usageModel) {
    this.usageModel = usageModel;
    return this;
  }

   /**
   * 1-非自建(如沃尔玛) 航信单盘／航信服务器 百望单盘／百望服务器 2-自建（如京客隆） 3-半自建（与航信合作部署，如碧桂园）
   * @return usageModel
  **/


  @ApiModelProperty(value = "1-非自建(如沃尔玛) 航信单盘／航信服务器 百望单盘／百望服务器 2-自建（如京客隆） 3-半自建（与航信合作部署，如碧桂园）")
  public String getUsageModel() {
    return usageModel;
  }

  public void setUsageModel(String usageModel) {
    this.usageModel = usageModel;
  }

  @JsonIgnore
  public CompanyRegisterInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 申请发票类型： ec-电普（usageModel为1/2/3时可选，含ec时同时申请CA）， c-纸普（usageModel为2时可选）， s-纸专（usageModel为2时可选）  另：多种发票类型时用”,”(英文逗号)分割
   * @return invoiceType
  **/


  @ApiModelProperty(value = "申请发票类型： ec-电普（usageModel为1/2/3时可选，含ec时同时申请CA）， c-纸普（usageModel为2时可选）， s-纸专（usageModel为2时可选）  另：多种发票类型时用”,”(英文逗号)分割")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public CompanyRegisterInfo companyAddress(String companyAddress) {
    this.companyAddress = companyAddress;
    return this;
  }

   /**
   * 公司地址
   * @return companyAddress
  **/


  @ApiModelProperty(value = "公司地址")
  public String getCompanyAddress() {
    return companyAddress;
  }

  public void setCompanyAddress(String companyAddress) {
    this.companyAddress = companyAddress;
  }

  @JsonIgnore
  public CompanyRegisterInfo companyTel(String companyTel) {
    this.companyTel = companyTel;
    return this;
  }

   /**
   * 公司电话
   * @return companyTel
  **/


  @ApiModelProperty(value = "公司电话")
  public String getCompanyTel() {
    return companyTel;
  }

  public void setCompanyTel(String companyTel) {
    this.companyTel = companyTel;
  }

  @JsonIgnore
  public CompanyRegisterInfo province(String province) {
    this.province = province;
    return this;
  }

   /**
   * 开户省份,会写入证书，请谨慎比对
   * @return province
  **/


  @ApiModelProperty(value = "开户省份,会写入证书，请谨慎比对")
  public String getProvince() {
    return province;
  }

  public void setProvince(String province) {
    this.province = province;
  }

  @JsonIgnore
  public CompanyRegisterInfo city(String city) {
    this.city = city;
    return this;
  }

   /**
   * 开户城市,将写入证书，请谨慎比对
   * @return city
  **/


  @ApiModelProperty(value = "开户城市,将写入证书，请谨慎比对")
  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  @JsonIgnore
  public CompanyRegisterInfo contactorName(String contactorName) {
    this.contactorName = contactorName;
    return this;
  }

   /**
   * 联系人姓名(若有身份证附件，与身份证附件保持一致)
   * @return contactorName
  **/


  @ApiModelProperty(value = "联系人姓名(若有身份证附件，与身份证附件保持一致)")
  public String getContactorName() {
    return contactorName;
  }

  public void setContactorName(String contactorName) {
    this.contactorName = contactorName;
  }

  @JsonIgnore
  public CompanyRegisterInfo contactorTel(String contactorTel) {
    this.contactorTel = contactorTel;
    return this;
  }

   /**
   * 联系人电话(若有身份证附件，与身份证附件保持一致)
   * @return contactorTel
  **/


  @ApiModelProperty(value = "联系人电话(若有身份证附件，与身份证附件保持一致)")
  public String getContactorTel() {
    return contactorTel;
  }

  public void setContactorTel(String contactorTel) {
    this.contactorTel = contactorTel;
  }

  @JsonIgnore
  public CompanyRegisterInfo contactorId(String contactorId) {
    this.contactorId = contactorId;
    return this;
  }

   /**
   * 联系人身份证ID (若有身份证附件，与身份证附件保持一致)
   * @return contactorId
  **/


  @ApiModelProperty(value = "联系人身份证ID (若有身份证附件，与身份证附件保持一致)")
  public String getContactorId() {
    return contactorId;
  }

  public void setContactorId(String contactorId) {
    this.contactorId = contactorId;
  }

  @JsonIgnore
  public CompanyRegisterInfo businessLicense(String businessLicense) {
    this.businessLicense = businessLicense;
    return this;
  }

   /**
   * 当invoiceType 含ec时，必填 营业执照/税务登记证： jpg，jpeg，png图片格式 文件小于300k，Base64加密文件字节串
   * @return businessLicense
  **/


  @ApiModelProperty(value = "当invoiceType 含ec时，必填 营业执照/税务登记证： jpg，jpeg，png图片格式 文件小于300k，Base64加密文件字节串")
  public String getBusinessLicense() {
    return businessLicense;
  }

  public void setBusinessLicense(String businessLicense) {
    this.businessLicense = businessLicense;
  }

  @JsonIgnore
  public CompanyRegisterInfo application(String application) {
    this.application = application;
    return this;
  }

   /**
   * 当invoiceType 含ec时，必填  申请书： jpg，jpeg，png图片格式 文件小于300k，Base64加密文件字节串
   * @return application
  **/


  @ApiModelProperty(value = "当invoiceType 含ec时，必填  申请书： jpg，jpeg，png图片格式 文件小于300k，Base64加密文件字节串")
  public String getApplication() {
    return application;
  }

  public void setApplication(String application) {
    this.application = application;
  }

  @JsonIgnore
  public CompanyRegisterInfo idFront(String idFront) {
    this.idFront = idFront;
    return this;
  }

   /**
   * 当invoiceType 含ec时，必填 身份证正面：jpg，jpeg，png图片格式文件小于300k，Base64加密文件字节串
   * @return idFront
  **/


  @ApiModelProperty(value = "当invoiceType 含ec时，必填 身份证正面：jpg，jpeg，png图片格式文件小于300k，Base64加密文件字节串")
  public String getIdFront() {
    return idFront;
  }

  public void setIdFront(String idFront) {
    this.idFront = idFront;
  }

  @JsonIgnore
  public CompanyRegisterInfo idBack(String idBack) {
    this.idBack = idBack;
    return this;
  }

   /**
   * 当invoiceType 含ec时，必填身份证背面：jpg，jpeg，png图片格式文件小于300k，Base64加密文件字节串
   * @return idBack
  **/


  @ApiModelProperty(value = "当invoiceType 含ec时，必填身份证背面：jpg，jpeg，png图片格式文件小于300k，Base64加密文件字节串")
  public String getIdBack() {
    return idBack;
  }

  public void setIdBack(String idBack) {
    this.idBack = idBack;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyRegisterInfo companyRegisterInfo = (CompanyRegisterInfo) o;
    return Objects.equals(this.requestSerialNo, companyRegisterInfo.requestSerialNo) &&
        Objects.equals(this.groupCode, companyRegisterInfo.groupCode) &&
        Objects.equals(this.companyName, companyRegisterInfo.companyName) &&
        Objects.equals(this.companyTaxNo, companyRegisterInfo.companyTaxNo) &&
        Objects.equals(this.operationType, companyRegisterInfo.operationType) &&
        Objects.equals(this.usageModel, companyRegisterInfo.usageModel) &&
        Objects.equals(this.invoiceType, companyRegisterInfo.invoiceType) &&
        Objects.equals(this.companyAddress, companyRegisterInfo.companyAddress) &&
        Objects.equals(this.companyTel, companyRegisterInfo.companyTel) &&
        Objects.equals(this.province, companyRegisterInfo.province) &&
        Objects.equals(this.city, companyRegisterInfo.city) &&
        Objects.equals(this.contactorName, companyRegisterInfo.contactorName) &&
        Objects.equals(this.contactorTel, companyRegisterInfo.contactorTel) &&
        Objects.equals(this.contactorId, companyRegisterInfo.contactorId) &&
        Objects.equals(this.businessLicense, companyRegisterInfo.businessLicense) &&
        Objects.equals(this.application, companyRegisterInfo.application) &&
        Objects.equals(this.idFront, companyRegisterInfo.idFront) &&
        Objects.equals(this.idBack, companyRegisterInfo.idBack);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestSerialNo, groupCode, companyName, companyTaxNo, operationType, usageModel, invoiceType, companyAddress, companyTel, province, city, contactorName, contactorTel, contactorId, businessLicense, application, idFront, idBack);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyRegisterInfo {\n");
    
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    groupCode: ").append(toIndentedString(groupCode)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    operationType: ").append(toIndentedString(operationType)).append("\n");
    sb.append("    usageModel: ").append(toIndentedString(usageModel)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    companyAddress: ").append(toIndentedString(companyAddress)).append("\n");
    sb.append("    companyTel: ").append(toIndentedString(companyTel)).append("\n");
    sb.append("    province: ").append(toIndentedString(province)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    contactorName: ").append(toIndentedString(contactorName)).append("\n");
    sb.append("    contactorTel: ").append(toIndentedString(contactorTel)).append("\n");
    sb.append("    contactorId: ").append(toIndentedString(contactorId)).append("\n");
    sb.append("    businessLicense: ").append(toIndentedString(businessLicense)).append("\n");
    sb.append("    application: ").append(toIndentedString(application)).append("\n");
    sb.append("    idFront: ").append(toIndentedString(idFront)).append("\n");
    sb.append("    idBack: ").append(toIndentedString(idBack)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
