package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CompanyRegisterInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CompanyRegisterRequest
 */

@JsonInclude(NON_NULL)
public class CompanyRegisterRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("companyRegisterInfo")
  private CompanyRegisterInfo companyRegisterInfo = null;

  @JsonIgnore
  public CompanyRegisterRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public CompanyRegisterRequest companyRegisterInfo(CompanyRegisterInfo companyRegisterInfo) {
    this.companyRegisterInfo = companyRegisterInfo;
    return this;
  }

   /**
   * 公司信息注册信息
   * @return companyRegisterInfo
  **/

  @Valid

  @ApiModelProperty(value = "公司信息注册信息")
  public CompanyRegisterInfo getCompanyRegisterInfo() {
    return companyRegisterInfo;
  }

  public void setCompanyRegisterInfo(CompanyRegisterInfo companyRegisterInfo) {
    this.companyRegisterInfo = companyRegisterInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyRegisterRequest companyRegisterRequest = (CompanyRegisterRequest) o;
    return Objects.equals(this.head, companyRegisterRequest.head) &&
        Objects.equals(this.companyRegisterInfo, companyRegisterRequest.companyRegisterInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, companyRegisterInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyRegisterRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    companyRegisterInfo: ").append(toIndentedString(companyRegisterInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
