package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class DeviceSortInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxDeviceType")
  private String taxDeviceType = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonIgnore
  public DeviceSortInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 纳税人识别号 （ASC 升序，DESC 降序）
   * @return taxNo
  **/


  @ApiModelProperty(value = "纳税人识别号 （ASC 升序，DESC 降序）")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public DeviceSortInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号 （ASC 升序，DESC 降序）
   * @return deviceNo
  **/


  @ApiModelProperty(value = "设备编号 （ASC 升序，DESC 降序）")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public DeviceSortInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称 （ASC 升序，DESC 降序）
   * @return companyName
  **/


  @ApiModelProperty(value = "公司名称 （ASC 升序，DESC 降序）")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public DeviceSortInfo taxDeviceType(String taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
    return this;
  }

   /**
   * 设备类型（ASC 升序，DESC 降序）
   * @return taxDeviceType
  **/


  @ApiModelProperty(value = "设备类型（ASC 升序，DESC 降序）")
  public String getTaxDeviceType() {
    return taxDeviceType;
  }

  public void setTaxDeviceType(String taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
  }

  @JsonIgnore
  public DeviceSortInfo createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间 （ASC 升序，DESC 降序）
   * @return createTime
  **/


  @ApiModelProperty(value = "创建时间 （ASC 升序，DESC 降序）")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceSortInfo deviceSortInfo = (DeviceSortInfo) o;
    return Objects.equals(this.taxNo, deviceSortInfo.taxNo) &&
        Objects.equals(this.deviceNo, deviceSortInfo.deviceNo) &&
        Objects.equals(this.companyName, deviceSortInfo.companyName) &&
        Objects.equals(this.taxDeviceType, deviceSortInfo.taxDeviceType) &&
        Objects.equals(this.createTime, deviceSortInfo.createTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNo, deviceNo, companyName, taxDeviceType, createTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceSortInfo {\n");
    
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
