package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.ThreePointFiveClientInvoiceStockInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceStockForThreePointFiveResponse
 */

@JsonInclude(NON_NULL)
public class InvoiceStockForThreePointFiveResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("clientInvoiceStockInfoList")
  private List<ThreePointFiveClientInvoiceStockInfo> clientInvoiceStockInfoList = new ArrayList<>();

  @JsonIgnore
  public InvoiceStockForThreePointFiveResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准响应头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准响应头信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceStockForThreePointFiveResponse clientInvoiceStockInfoList(List<ThreePointFiveClientInvoiceStockInfo> clientInvoiceStockInfoList) {
    this.clientInvoiceStockInfoList = clientInvoiceStockInfoList;
    return this;
  }

  public InvoiceStockForThreePointFiveResponse addClientInvoiceStockInfoListItem(ThreePointFiveClientInvoiceStockInfo clientInvoiceStockInfoListItem) {
    this.clientInvoiceStockInfoList.add(clientInvoiceStockInfoListItem);
    return this;
  }

   /**
   * 3.5客户端库存信息
   * @return clientInvoiceStockInfoList
  **/

  @Valid

  @ApiModelProperty(value = "3.5客户端库存信息")
  public List<ThreePointFiveClientInvoiceStockInfo> getClientInvoiceStockInfoList() {
    return clientInvoiceStockInfoList;
  }

  public void setClientInvoiceStockInfoList(List<ThreePointFiveClientInvoiceStockInfo> clientInvoiceStockInfoList) {
    this.clientInvoiceStockInfoList = clientInvoiceStockInfoList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceStockForThreePointFiveResponse invoiceStockForThreePointFiveResponse = (InvoiceStockForThreePointFiveResponse) o;
    return Objects.equals(this.head, invoiceStockForThreePointFiveResponse.head) &&
        Objects.equals(this.clientInvoiceStockInfoList, invoiceStockForThreePointFiveResponse.clientInvoiceStockInfoList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, clientInvoiceStockInfoList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceStockForThreePointFiveResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    clientInvoiceStockInfoList: ").append(toIndentedString(clientInvoiceStockInfoList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
