package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 发票终端库存明细
 */
@ApiModel(description = "发票终端库存明细")

@JsonInclude(NON_NULL)
public class InvoiceTerminalStockDetail implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("invoiceStockNum")
  private Long invoiceStockNum = null;

  @JsonIgnore
  public InvoiceTerminalStockDetail terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端标识
   * @return terminalNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "终端标识")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public InvoiceTerminalStockDetail invoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
    return this;
  }

   /**
   * 剩余份数
   * @return invoiceStockNum
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "剩余份数")
  public Long getInvoiceStockNum() {
    return invoiceStockNum;
  }

  public void setInvoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceTerminalStockDetail invoiceTerminalStockDetail = (InvoiceTerminalStockDetail) o;
    return Objects.equals(this.terminalNo, invoiceTerminalStockDetail.terminalNo) &&
        Objects.equals(this.invoiceStockNum, invoiceTerminalStockDetail.invoiceStockNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalNo, invoiceStockNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceTerminalStockDetail {\n");
    
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    invoiceStockNum: ").append(toIndentedString(invoiceStockNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
