package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * LicenseKeyResponse
 */

@JsonInclude(NON_NULL)
public class LicenseKeyResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("key")
  private String key = null;

  @JsonProperty("days")
  private Long days = null;

  @JsonIgnore
  public LicenseKeyResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询授权文件激活码响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询授权文件激活码响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public LicenseKeyResponse key(String key) {
    this.key = key;
    return this;
  }

   /**
   * 激活码
   * @return key
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "激活码")
  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @JsonIgnore
  public LicenseKeyResponse days(Long days) {
    this.days = days;
    return this;
  }

   /**
   * 激活码剩余有效天数
   * @return days
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "激活码剩余有效天数")
  public Long getDays() {
    return days;
  }

  public void setDays(Long days) {
    this.days = days;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseKeyResponse licenseKeyResponse = (LicenseKeyResponse) o;
    return Objects.equals(this.head, licenseKeyResponse.head) &&
        Objects.equals(this.key, licenseKeyResponse.key) &&
        Objects.equals(this.days, licenseKeyResponse.days);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, key, days);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LicenseKeyResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    days: ").append(toIndentedString(days)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
