package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class OriginAccountTerminalInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("terminalMode")
  private Integer terminalMode = null;

  @JsonProperty("deployType")
  private Integer deployType = null;

  @JsonIgnore
  public OriginAccountTerminalInfo terminalMode(Integer terminalMode) {
    this.terminalMode = terminalMode;
    return this;
  }

   /**
   * 终端物理设备类型，1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器
   * @return terminalMode
  **/


  @ApiModelProperty(value = "终端物理设备类型，1 百望单盘 2 百望服务器  3 航信单盘 4 航信服务器")
  public Integer getTerminalMode() {
    return terminalMode;
  }

  public void setTerminalMode(Integer terminalMode) {
    this.terminalMode = terminalMode;
  }

  @JsonIgnore
  public OriginAccountTerminalInfo deployType(Integer deployType) {
    this.deployType = deployType;
    return this;
  }

   /**
   * 部署类型，1 票易通部署 2 非票易通部署
   * @return deployType
  **/


  @ApiModelProperty(value = "部署类型，1 票易通部署 2 非票易通部署")
  public Integer getDeployType() {
    return deployType;
  }

  public void setDeployType(Integer deployType) {
    this.deployType = deployType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OriginAccountTerminalInfo originAccountTerminalInfo = (OriginAccountTerminalInfo) o;
    return Objects.equals(this.terminalMode, originAccountTerminalInfo.terminalMode) &&
        Objects.equals(this.deployType, originAccountTerminalInfo.deployType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalMode, deployType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OriginAccountTerminalInfo {\n");
    
    sb.append("    terminalMode: ").append(toIndentedString(terminalMode)).append("\n");
    sb.append("    deployType: ").append(toIndentedString(deployType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
