package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryQueueStatusRequest
 */

@JsonInclude(NON_NULL)
public class QueryQueueStatusRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public QueryQueueStatusRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryQueueStatusRequest queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * 队列名称
   * @return queueName
  **/


  @ApiModelProperty(value = "队列名称")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public QueryQueueStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 0-不在线，1-在线
   * @return status
  **/


  @ApiModelProperty(value = "0-不在线，1-在线")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryQueueStatusRequest queryQueueStatusRequest = (QueryQueueStatusRequest) o;
    return Objects.equals(this.head, queryQueueStatusRequest.head) &&
        Objects.equals(this.queueName, queryQueueStatusRequest.queueName) &&
        Objects.equals(this.status, queryQueueStatusRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queueName, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryQueueStatusRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
