package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.QueueInfo;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryQueueStatusResponse
 */

@JsonInclude(NON_NULL)
public class QueryQueueStatusResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("queues")
  private List<QueueInfo> queues = new ArrayList<>();

  @JsonIgnore
  public QueryQueueStatusResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 队列在线情况查询响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "队列在线情况查询响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryQueueStatusResponse queues(List<QueueInfo> queues) {
    this.queues = queues;
    return this;
  }

  public QueryQueueStatusResponse addQueuesItem(QueueInfo queuesItem) {
    this.queues.add(queuesItem);
    return this;
  }

   /**
   * 队列信息
   * @return queues
  **/

  @Valid

  @ApiModelProperty(value = "队列信息")
  public List<QueueInfo> getQueues() {
    return queues;
  }

  public void setQueues(List<QueueInfo> queues) {
    this.queues = queues;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryQueueStatusResponse queryQueueStatusResponse = (QueryQueueStatusResponse) o;
    return Objects.equals(this.head, queryQueueStatusResponse.head) &&
        Objects.equals(this.queues, queryQueueStatusResponse.queues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queues);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryQueueStatusResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queues: ").append(toIndentedString(queues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
