package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.PageInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import com.xforceplus.micro.tax.device.contract.model.TerminalQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.TerminalSortInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryTerminalRequest
 */

@JsonInclude(NON_NULL)
public class QueryTerminalRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("terminalInfo")
  private TerminalQueryInfo terminalInfo = null;

  @JsonProperty("pageInfo")
  private PageInfo pageInfo = null;

  @JsonProperty("sortInfo")
  private TerminalSortInfo sortInfo = null;

  @JsonProperty("queryServiceState")
  private Boolean queryServiceState = null;

  @JsonProperty("queryStock")
  private Boolean queryStock = false;

  @JsonProperty("queryInventory")
  private Boolean queryInventory = false;

  @JsonProperty("queryKey")
  private Boolean queryKey = false;

  @JsonIgnore
  public QueryTerminalRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryTerminalRequest terminalInfo(TerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/

  @Valid

  @ApiModelProperty(value = "终端信息")
  public TerminalQueryInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(TerminalQueryInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }

  @JsonIgnore
  public QueryTerminalRequest pageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
    return this;
  }

   /**
   * 分页信息
   * @return pageInfo
  **/

  @Valid

  @ApiModelProperty(value = "分页信息")
  public PageInfo getPageInfo() {
    return pageInfo;
  }

  public void setPageInfo(PageInfo pageInfo) {
    this.pageInfo = pageInfo;
  }

  @JsonIgnore
  public QueryTerminalRequest sortInfo(TerminalSortInfo sortInfo) {
    this.sortInfo = sortInfo;
    return this;
  }

   /**
   * 排序信息
   * @return sortInfo
  **/

  @Valid

  @ApiModelProperty(value = "排序信息")
  public TerminalSortInfo getSortInfo() {
    return sortInfo;
  }

  public void setSortInfo(TerminalSortInfo sortInfo) {
    this.sortInfo = sortInfo;
  }

  @JsonIgnore
  public QueryTerminalRequest queryServiceState(Boolean queryServiceState) {
    this.queryServiceState = queryServiceState;
    return this;
  }

   /**
   * 查询在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）
   * @return queryServiceState
  **/


  @ApiModelProperty(value = "查询在线状态（注意：此字段不会进入条件筛选，只会在满足上述条件后进行额外的在线情况获取）")
  public Boolean QueryServiceState() {
    return queryServiceState;
  }

  public void setQueryServiceState(Boolean queryServiceState) {
    this.queryServiceState = queryServiceState;
  }

  @JsonIgnore
  public QueryTerminalRequest queryStock(Boolean queryStock) {
    this.queryStock = queryStock;
    return this;
  }

   /**
   * 查询库存(目前仅支持VUkey终端和单盘终端，单盘终端设备必须在线),true：查询 false：不查询
   * @return queryStock
  **/


  @ApiModelProperty(value = "查询库存(目前仅支持VUkey终端和单盘终端，单盘终端设备必须在线),true：查询 false：不查询")
  public Boolean QueryStock() {
    return queryStock;
  }

  public void setQueryStock(Boolean queryStock) {
    this.queryStock = queryStock;
  }

  @JsonIgnore
  public QueryTerminalRequest queryInventory(Boolean queryInventory) {
    this.queryInventory = queryInventory;
    return this;
  }

   /**
   * 查询库存(目前仅支持VUkey终端和单盘终端，单盘终端设备必须在线),true：查询 false：不查询
   * @return queryInventory
  **/


  @ApiModelProperty(value = "查询库存(目前仅支持VUkey终端和单盘终端，单盘终端设备必须在线),true：查询 false：不查询")
  public Boolean QueryInventory() {
    return queryInventory;
  }

  public void setQueryInventory(Boolean queryInventory) {
    this.queryInventory = queryInventory;
  }

  @JsonIgnore
  public QueryTerminalRequest queryKey(Boolean queryKey) {
    this.queryKey = queryKey;
    return this;
  }

   /**
   * 查询终端激活码,true：查询 false：不查询
   * @return queryKey
  **/


  @ApiModelProperty(value = "查询终端激活码,true：查询 false：不查询")
  public Boolean QueryKey() {
    return queryKey;
  }

  public void setQueryKey(Boolean queryKey) {
    this.queryKey = queryKey;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryTerminalRequest queryTerminalRequest = (QueryTerminalRequest) o;
    return Objects.equals(this.head, queryTerminalRequest.head) &&
        Objects.equals(this.terminalInfo, queryTerminalRequest.terminalInfo) &&
        Objects.equals(this.pageInfo, queryTerminalRequest.pageInfo) &&
        Objects.equals(this.sortInfo, queryTerminalRequest.sortInfo) &&
        Objects.equals(this.queryServiceState, queryTerminalRequest.queryServiceState) &&
        Objects.equals(this.queryStock, queryTerminalRequest.queryStock) &&
        Objects.equals(this.queryInventory, queryTerminalRequest.queryInventory) &&
        Objects.equals(this.queryKey, queryTerminalRequest.queryKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalInfo, pageInfo, sortInfo, queryServiceState, queryStock, queryInventory, queryKey);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryTerminalRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("    pageInfo: ").append(toIndentedString(pageInfo)).append("\n");
    sb.append("    sortInfo: ").append(toIndentedString(sortInfo)).append("\n");
    sb.append("    queryServiceState: ").append(toIndentedString(queryServiceState)).append("\n");
    sb.append("    queryStock: ").append(toIndentedString(queryStock)).append("\n");
    sb.append("    queryInventory: ").append(toIndentedString(queryInventory)).append("\n");
    sb.append("    queryKey: ").append(toIndentedString(queryKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
