package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.InvoiceTerminalStockDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 服务器端库存信息
 */
@ApiModel(description = "服务器端库存信息")

@JsonInclude(NON_NULL)
public class ServerInvoiceStockInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("deviceName")
  private String deviceName = null;

  @JsonProperty("code")
  private Integer code = 1;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceStockNum")
  private Long invoiceStockNum = null;

  @JsonProperty("notDispatchInvoiceStockNum")
  private Long notDispatchInvoiceStockNum = null;

  @JsonProperty("invoiceTerminalStockDetailList")
  private List<InvoiceTerminalStockDetail> invoiceTerminalStockDetailList = new ArrayList<>();

  @JsonIgnore
  public ServerInvoiceStockInfo deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id（已废弃，用deviceUn代替）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id（已废弃，用deviceUn代替）")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUn
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "设备唯一码")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo deviceName(String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

   /**
   * 设备名称
   * @return deviceName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "设备名称")
  public String getDeviceName() {
    return deviceName;
  }

  public void setDeviceName(String deviceName) {
    this.deviceName = deviceName;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 返回代码 正数成功, 负数失败
   * @return code
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "返回代码 正数成功, 负数失败")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo message(String message) {
    this.message = message;
    return this;
  }

   /**
   * 返回信息
   * @return message
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "返回信息")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 公司税号
   * @return taxNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "公司税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型
   * @return invoiceType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票类型")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo invoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
    return this;
  }

   /**
   * 剩余发票总数
   * @return invoiceStockNum
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "剩余发票总数")
  public Long getInvoiceStockNum() {
    return invoiceStockNum;
  }

  public void setInvoiceStockNum(Long invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo notDispatchInvoiceStockNum(Long notDispatchInvoiceStockNum) {
    this.notDispatchInvoiceStockNum = notDispatchInvoiceStockNum;
    return this;
  }

   /**
   * 未分发总数
   * @return notDispatchInvoiceStockNum
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "未分发总数")
  public Long getNotDispatchInvoiceStockNum() {
    return notDispatchInvoiceStockNum;
  }

  public void setNotDispatchInvoiceStockNum(Long notDispatchInvoiceStockNum) {
    this.notDispatchInvoiceStockNum = notDispatchInvoiceStockNum;
  }

  @JsonIgnore
  public ServerInvoiceStockInfo invoiceTerminalStockDetailList(List<InvoiceTerminalStockDetail> invoiceTerminalStockDetailList) {
    this.invoiceTerminalStockDetailList = invoiceTerminalStockDetailList;
    return this;
  }

  public ServerInvoiceStockInfo addInvoiceTerminalStockDetailListItem(InvoiceTerminalStockDetail invoiceTerminalStockDetailListItem) {
    this.invoiceTerminalStockDetailList.add(invoiceTerminalStockDetailListItem);
    return this;
  }

   /**
   * 发票终端库存明细
   * @return invoiceTerminalStockDetailList
  **/

  @Valid

  @ApiModelProperty(value = "发票终端库存明细")
  public List<InvoiceTerminalStockDetail> getInvoiceTerminalStockDetailList() {
    return invoiceTerminalStockDetailList;
  }

  public void setInvoiceTerminalStockDetailList(List<InvoiceTerminalStockDetail> invoiceTerminalStockDetailList) {
    this.invoiceTerminalStockDetailList = invoiceTerminalStockDetailList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServerInvoiceStockInfo serverInvoiceStockInfo = (ServerInvoiceStockInfo) o;
    return Objects.equals(this.deviceId, serverInvoiceStockInfo.deviceId) &&
        Objects.equals(this.deviceUn, serverInvoiceStockInfo.deviceUn) &&
        Objects.equals(this.deviceNo, serverInvoiceStockInfo.deviceNo) &&
        Objects.equals(this.deviceName, serverInvoiceStockInfo.deviceName) &&
        Objects.equals(this.code, serverInvoiceStockInfo.code) &&
        Objects.equals(this.message, serverInvoiceStockInfo.message) &&
        Objects.equals(this.taxNo, serverInvoiceStockInfo.taxNo) &&
        Objects.equals(this.invoiceType, serverInvoiceStockInfo.invoiceType) &&
        Objects.equals(this.invoiceStockNum, serverInvoiceStockInfo.invoiceStockNum) &&
        Objects.equals(this.notDispatchInvoiceStockNum, serverInvoiceStockInfo.notDispatchInvoiceStockNum) &&
        Objects.equals(this.invoiceTerminalStockDetailList, serverInvoiceStockInfo.invoiceTerminalStockDetailList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deviceId, deviceUn, deviceNo, deviceName, code, message, taxNo, invoiceType, invoiceStockNum, notDispatchInvoiceStockNum, invoiceTerminalStockDetailList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServerInvoiceStockInfo {\n");
    
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    deviceName: ").append(toIndentedString(deviceName)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceStockNum: ").append(toIndentedString(invoiceStockNum)).append("\n");
    sb.append("    notDispatchInvoiceStockNum: ").append(toIndentedString(notDispatchInvoiceStockNum)).append("\n");
    sb.append("    invoiceTerminalStockDetailList: ").append(toIndentedString(invoiceTerminalStockDetailList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
