package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 税盘信息
 */
@ApiModel(description = "税盘信息")

@JsonInclude(NON_NULL)
public class TaxDiscInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("machineNo")
  private String machineNo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonIgnore
  public TaxDiscInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号
   * @return taxNo
  **/


  @ApiModelProperty(value = "税号")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public TaxDiscInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/


  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public TaxDiscInfo machineNo(String machineNo) {
    this.machineNo = machineNo;
    return this;
  }

   /**
   * 开票机号
   * @return machineNo
  **/


  @ApiModelProperty(value = "开票机号")
  public String getMachineNo() {
    return machineNo;
  }

  public void setMachineNo(String machineNo) {
    this.machineNo = machineNo;
  }

  @JsonIgnore
  public TaxDiscInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 税控盘号
   * @return deviceNo
  **/


  @ApiModelProperty(value = "税控盘号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaxDiscInfo taxDiscInfo = (TaxDiscInfo) o;
    return Objects.equals(this.taxNo, taxDiscInfo.taxNo) &&
        Objects.equals(this.sellerName, taxDiscInfo.sellerName) &&
        Objects.equals(this.machineNo, taxDiscInfo.machineNo) &&
        Objects.equals(this.deviceNo, taxDiscInfo.deviceNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNo, sellerName, machineNo, deviceNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaxDiscInfo {\n");
    
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    machineNo: ").append(toIndentedString(machineNo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
