package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CompanyInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 终端信息
 */
@ApiModel(description = "终端信息")

@JsonInclude(NON_NULL)
public class TerminalQueryInfo implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("terminalIds")
  private List<Long> terminalIds = new ArrayList<>();

  @JsonProperty("terminalUns")
  private List<String> terminalUns = new ArrayList<>();

  @JsonProperty("companyInfo")
  private CompanyInfo companyInfo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<>();

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("supportService")
  private List<String> supportService = new ArrayList<>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public TerminalQueryInfo terminalIds(List<Long> terminalIds) {
    this.terminalIds = terminalIds;
    return this;
  }

  public TerminalQueryInfo addTerminalIdsItem(Long terminalIdsItem) {
    this.terminalIds.add(terminalIdsItem);
    return this;
  }

   /**
   * 终端id（已废弃，用terminalUns代替）
   * @return terminalIds
  **/


  @ApiModelProperty(value = "终端id（已废弃，用terminalUns代替）")
  public List<Long> getTerminalIds() {
    return terminalIds;
  }

  public void setTerminalIds(List<Long> terminalIds) {
    this.terminalIds = terminalIds;
  }

  @JsonIgnore
  public TerminalQueryInfo terminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
    return this;
  }

  public TerminalQueryInfo addTerminalUnsItem(String terminalUnsItem) {
    this.terminalUns.add(terminalUnsItem);
    return this;
  }

   /**
   * 终端唯一码
   * @return terminalUns
  **/


  @ApiModelProperty(value = "终端唯一码")
  public List<String> getTerminalUns() {
    return terminalUns;
  }

  public void setTerminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
  }

  @JsonIgnore
  public TerminalQueryInfo companyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

   /**
   * 公司信息
   * @return companyInfo
  **/

  @Valid

  @ApiModelProperty(value = "公司信息")
  public CompanyInfo getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(CompanyInfo companyInfo) {
    this.companyInfo = companyInfo;
  }

  @JsonIgnore
  public TerminalQueryInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 终端编号
   * @return terminalNo
  **/


  @ApiModelProperty(value = "终端编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public TerminalQueryInfo terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端名称
   * @return terminalName
  **/


  @ApiModelProperty(value = "终端名称")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public TerminalQueryInfo invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public TerminalQueryInfo addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，v2:二手机动车发票）")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public TerminalQueryInfo terminalType(Integer terminalType) {
    this.terminalType = terminalType;
    return this;
  }

   /**
   * 终端类型 1：单盘 2：服务器  3:底账服务器  4:区块链终端 5:VUKey终端
   * @return terminalType
  **/


  @ApiModelProperty(value = "终端类型 1：单盘 2：服务器  3:底账服务器  4:区块链终端 5:VUKey终端")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  @JsonIgnore
  public TerminalQueryInfo supportService(List<String> supportService) {
    this.supportService = supportService;
    return this;
  }

  public TerminalQueryInfo addSupportServiceItem(String supportServiceItem) {
    this.supportService.add(supportServiceItem);
    return this;
  }

   /**
   * 支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）
   * @return supportService
  **/


  @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }

  @JsonIgnore
  public TerminalQueryInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 ）
   * @return status
  **/


  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 ）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalQueryInfo terminalQueryInfo = (TerminalQueryInfo) o;
    return Objects.equals(this.terminalIds, terminalQueryInfo.terminalIds) &&
        Objects.equals(this.terminalUns, terminalQueryInfo.terminalUns) &&
        Objects.equals(this.companyInfo, terminalQueryInfo.companyInfo) &&
        Objects.equals(this.terminalNo, terminalQueryInfo.terminalNo) &&
        Objects.equals(this.terminalName, terminalQueryInfo.terminalName) &&
        Objects.equals(this.invoiceType, terminalQueryInfo.invoiceType) &&
        Objects.equals(this.terminalType, terminalQueryInfo.terminalType) &&
        Objects.equals(this.supportService, terminalQueryInfo.supportService) &&
        Objects.equals(this.status, terminalQueryInfo.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalIds, terminalUns, companyInfo, terminalNo, terminalName, invoiceType, terminalType, supportService, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalQueryInfo {\n");
    
    sb.append("    terminalIds: ").append(toIndentedString(terminalIds)).append("\n");
    sb.append("    terminalUns: ").append(toIndentedString(terminalUns)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    terminalType: ").append(toIndentedString(terminalType)).append("\n");
    sb.append("    supportService: ").append(toIndentedString(supportService)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
