package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.LicenseInfo;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * UpdateTerminalStatusRequest
 */

@JsonInclude(NON_NULL)
public class UpdateTerminalStatusRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("terminalId")
  private List<Long> terminalId = new ArrayList<>();

  @JsonProperty("terminalUns")
  private List<String> terminalUns = new ArrayList<>();

  @JsonProperty("fromSystem")
  private String fromSystem = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonProperty("licenseInfo")
  private LicenseInfo licenseInfo = null;

  @JsonIgnore
  public UpdateTerminalStatusRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public UpdateTerminalStatusRequest terminalId(List<Long> terminalId) {
    this.terminalId = terminalId;
    return this;
  }

  public UpdateTerminalStatusRequest addTerminalIdItem(Long terminalIdItem) {
    this.terminalId.add(terminalIdItem);
    return this;
  }

   /**
   * 终端id（已废弃，用terminalUns代替）
   * @return terminalId
  **/


  @ApiModelProperty(value = "终端id（已废弃，用terminalUns代替）")
  public List<Long> getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(List<Long> terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public UpdateTerminalStatusRequest terminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
    return this;
  }

  public UpdateTerminalStatusRequest addTerminalUnsItem(String terminalUnsItem) {
    this.terminalUns.add(terminalUnsItem);
    return this;
  }

   /**
   * 终端唯一码
   * @return terminalUns
  **/


  @ApiModelProperty(value = "终端唯一码")
  public List<String> getTerminalUns() {
    return terminalUns;
  }

  public void setTerminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
  }

  @JsonIgnore
  public UpdateTerminalStatusRequest fromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
    return this;
  }

   /**
   * 来源系统
   * @return fromSystem
  **/


  @ApiModelProperty(value = "来源系统")
  public String getFromSystem() {
    return fromSystem;
  }

  public void setFromSystem(String fromSystem) {
    this.fromSystem = fromSystem;
  }

  @JsonIgnore
  public UpdateTerminalStatusRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 22：作废）
   * @return status
  **/


  @ApiModelProperty(value = "状态（0：待审核 1:审核通过  2：审核失败  11：启用 12：未启用 21：关闭 22：作废）")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public UpdateTerminalStatusRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }

  @JsonIgnore
  public UpdateTerminalStatusRequest licenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
    return this;
  }

   /**
   * 授权文件信息
   * @return licenseInfo
  **/

  @Valid

  @ApiModelProperty(value = "授权文件信息")
  public LicenseInfo getLicenseInfo() {
    return licenseInfo;
  }

  public void setLicenseInfo(LicenseInfo licenseInfo) {
    this.licenseInfo = licenseInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateTerminalStatusRequest updateTerminalStatusRequest = (UpdateTerminalStatusRequest) o;
    return Objects.equals(this.head, updateTerminalStatusRequest.head) &&
        Objects.equals(this.terminalId, updateTerminalStatusRequest.terminalId) &&
        Objects.equals(this.terminalUns, updateTerminalStatusRequest.terminalUns) &&
        Objects.equals(this.fromSystem, updateTerminalStatusRequest.fromSystem) &&
        Objects.equals(this.status, updateTerminalStatusRequest.status) &&
        Objects.equals(this.operateInfo, updateTerminalStatusRequest.operateInfo) &&
        Objects.equals(this.licenseInfo, updateTerminalStatusRequest.licenseInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, terminalId, terminalUns, fromSystem, status, operateInfo, licenseInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateTerminalStatusRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    terminalUns: ").append(toIndentedString(terminalUns)).append("\n");
    sb.append("    fromSystem: ").append(toIndentedString(fromSystem)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("    licenseInfo: ").append(toIndentedString(licenseInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
