package com.xforceplus.micro.tax.device.contract.model.client;

import lombok.Data;

import java.util.List;

/**
 * @author Bobo
 * @create 2020/11/30 17:00
 * @since 1.0.0
 */
@Data
public class ClientOpenCardEvent {

    /**
     * 客户端最后开卡时间
     */
    private String clientLastOpenCardAt;

    /**
     * 税号
     */
    private String taxNo;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 税盘编号
     */
    private String machineCode;

    /**
     * 开票机号
     */
    private String diskNo;

    /**
     * 厂商(HX-航信, BW-百旺)
     */
    private String vendorType;

    /**
     * mi(mi账号, 税号_开票机号, 厂商_税盘序列号)
     */
    private String mi;

    /**
     * 处理码(TXWR000000为成功，其他都是失败)
     */
    private String processCode;

    /**
     * 处理信息
     */
    private String processRemark;

    /**
     * 纳税人性质(NormalTaxPayer:一般纳税人, SmallTaxPayer-小规模纳税人)
     */
    private String natureTaxPayer;

    /**
     * 成品油企业标志（0=否，1=是）
     */
    private String isRefinedOil;

    /**
     * 开票模式（A、A2、B、BPlus、...）
     */
    private String miKind;

    /**
     * 税盘密码（百旺才会用到）
     */
    private String taxDiskPwd;

    /**
     * 证书密码（航信和百旺都会用到）
     */
    private String certificatePwd;

    /**
     * 国税密码（航信和百旺都会用到）
     */
    private String nationalPwd;

    /**
     * 统计确认密码（只有底账会用到）
     */
    private String elConfirmPwd;

    /**
     * 税盘开票限制信息
     */
    private List<TaxDiskLimitInfo> limitInfo;

    /**
     * 国税地址
     */
    private String chinaTaxAddress;

    /**
     * 服务器开票使用的税控钥匙的证书
     */
    private List<CertificationOfKey> certsOfKey;

}
