package com.xforceplus.micro.tax.device.contract.model.client;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 获取配置文件消息
 *
 * @author Bobo
 * @create 2020/11/25 15:17
 * @since 1.0.0
 */
public class QueryConfigMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private QueryConfigMessage.Response.Result result = new QueryConfigMessage.Response.Result();

        @Data
        public static class Result {

            private List<QueryConfigMessage.Response.Config> configList;

        }

        @Data
        public static class Config {

            /**
             * 配置key
             */
            private String configKey;

            /**
             * 配置value
             */
            private String configValue;

        }

    }
}
