package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户端获取激活码消息
 *
 * @author Bobo
 * @create 2020/11/5 10:45
 * @since 1.0.0
 */
public class ClientActivationCodeMessage {

    @Data
    public static class Request {

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 客户端编号
         */
        private String cid;

        /**
         * 租户名称
         */
        private String tenantName;

        /**
         * 设备
         */
        private DeviceDto deviceInfo = new DeviceDto();

        @Data
        public static class DeviceDto {

            /**
             * 厂商标识
             * BW:百旺税控盘 HX:航信金税盘 EK:税务UKey
             */
            private String vendorType;

            /**
             * 设备编号
             */
            private String deviceNo;

            /**
             * 开票机号
             */
            private Integer invoicingMachineNo;

            /**
             * 税务数字证书密码
             */
            private String taxDeviceDigitalPassword;

            /**
             * 税控盘密码
             */
            private String taxDevicePassword;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();
    }

    @Data
    public static class Result {

        /**
         * 终端唯一码
         */
        private String terminalUn;

        /**
         * 设备唯一编号
         */
        private String deviceUn;

        /**
         * 激活码
         */
        private String activationCode;

    }

}
