package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 税盘类型查询
 *
 * @author Bobo
 * @create 2021/1/18 17:04
 * @since 1.0.0
 */
public class DeviceTypeQueryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private DeviceTypeQueryMessage.Result result = new DeviceTypeQueryMessage.Result();

    }

    @Data
    public static class Result {

        private List<DeviceTypeQueryMessage.DeviceType> deviceTypeList;

    }

    @Data
    public static class DeviceType {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 设备类型
         * bwClient-百旺单盘
         * hxClient-航信单盘
         * bwServer-百旺服务器
         * hxServer-航信服务器
         * vUKey-虚拟UKey
         * uKey-实体UKey
         */
        private String deviceType;

    }
}
