package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 查询抵账服务器是否开通消息
 *
 * @author Bobo
 * @create 2020/4/21 20:44
 * @since 1.0.0
 */
public class ELServiceMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            private List<ElService> elServices;

        }

        @Data
        public static class ElService {

            /**
             * 税号
             */
            private String taxCode;

            /**
             * 抵账服务是否开通
             */
            private boolean isEnabled;

        }

    }
}
