package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 终端激活查询消息
 *
 * @author Bobo
 * @create 2020/8/21 15:49
 * @since 1.0.0
 */
public class TerminalActivatedMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private TerminalActivatedMessage.Response.Result result = new TerminalActivatedMessage.Response.Result();

        @Data
        public static class Result {

            private List<TerminalActivatedMessage.Response.TerminalActivated> terminals;

        }

        @Data
        public static class TerminalActivated {

            /**
             * 税号
             */
            private String taxCode;

            /**
             * 终端唯一码
             */
            private String terminalUn;

            /**
             * 终端状态（11：启用 12：未启用 21：关闭）
             */
            private String status;

            /**
             * 是否激活，true：已激活，false：未激活
             */
            private boolean activated;

            /**
             * 激活时间（yyyy-MM-dd HH:mm:ss）
             */
            private String activatedDate;

        }

    }

}
