package com.xforceplus.micro.tax.device.contract.model.hardware;

import com.xforceplus.micro.tax.device.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Bobo
 * @create 2020/12/11 15:35
 * @since 1.0.0
 */
public class TrusteeshipDeviceStatusMessage {


    @Data
    public static class Request {

        /**
         * 容忍度忽略标识,默认false
         */
        private boolean ignoreToleranceFlag;

        /**
         * Mi账号
         */
        private List<String> accounts;

        /**
         * 查询范围（all:所有,online:在线，offline:不在线,默认all
         */
        private String queryScope = "all";

        /**
         * 是否需要查询hostname,默认:true
         */
        private boolean needHostname = true;

    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private TrusteeshipDeviceStatusMessage.Response.Result result = new TrusteeshipDeviceStatusMessage.Response.Result();

        @Data
        public class Result {

            /**
             * 设备状态
             */
            private List<DeviceStatusDto> status;

        }

    }

    @Data
    public static class DeviceStatusDto {

        /**
         * 账号
         */
        private String account;

        /**
         * 主机名
         */
        private String hostname;

        /**
         * 直连线标志
         */
        private boolean onlineFlag;

        /**
         * 在线倒计时（单位：毫秒）
         */
        private Long countdown;

        /**
         * 客户端最后一次开票时间或客户端最后一次上抛心跳时间
         * 格式：yyyyMMddHHmmss
         */
        private String lastTimeStamp;

    }
}
