package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireExtractRequest
 */

@JsonInclude(NON_NULL)
public class AcquireExtractRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("extractType")
  private Integer extractType = null;

  @JsonProperty("extractValue")
  private String extractValue = null;

  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonIgnore
  public AcquireExtractRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireExtractRequest extractType(Integer extractType) {
    this.extractType = extractType;
    return this;
  }

   /**
   * 抽取类型：1【抵账】2【税盘】3【销项】
   * @return extractType
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "抽取类型：1【抵账】2【税盘】3【销项】")
  public Integer getExtractType() {
    return extractType;
  }

  public void setExtractType(Integer extractType) {
    this.extractType = extractType;
  }

  @JsonIgnore
  public AcquireExtractRequest extractValue(String extractValue) {
    this.extractValue = extractValue;
    return this;
  }

   /**
   * 类型值【可以不传，不传获取相应类型下的所有订阅数据】：抵账与销项传税号，税盘传设备ID
   * @return extractValue
  **/


  @ApiModelProperty(value = "类型值【可以不传，不传获取相应类型下的所有订阅数据】：抵账与销项传税号，税盘传设备ID")
  public String getExtractValue() {
    return extractValue;
  }

  public void setExtractValue(String extractValue) {
    this.extractValue = extractValue;
  }

  @JsonIgnore
  public AcquireExtractRequest taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号【查询税盘订阅，当类型值为空时，税号 + 开票机号，可组合查询税盘订阅数据】
   * @return taxNo
  **/


  @ApiModelProperty(value = "税号【查询税盘订阅，当类型值为空时，税号 + 开票机号，可组合查询税盘订阅数据】")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public AcquireExtractRequest taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 开票机号【查询税盘订阅，当类型值为空时，税号 + 开票机号，可组合查询税盘订阅数据】
   * @return taxDeviceMachineNo
  **/


  @ApiModelProperty(value = "开票机号【查询税盘订阅，当类型值为空时，税号 + 开票机号，可组合查询税盘订阅数据】")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }

  @JsonIgnore
  public AcquireExtractRequest deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号【查询税盘订阅，当类型值为空时，优先通过设备编号查询税盘订阅数据】
   * @return deviceNo
  **/


  @ApiModelProperty(value = "设备编号【查询税盘订阅，当类型值为空时，优先通过设备编号查询税盘订阅数据】")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireExtractRequest acquireExtractRequest = (AcquireExtractRequest) o;
    return Objects.equals(this.head, acquireExtractRequest.head) &&
        Objects.equals(this.extractType, acquireExtractRequest.extractType) &&
        Objects.equals(this.extractValue, acquireExtractRequest.extractValue) &&
        Objects.equals(this.taxNo, acquireExtractRequest.taxNo) &&
        Objects.equals(this.taxDeviceMachineNo, acquireExtractRequest.taxDeviceMachineNo) &&
        Objects.equals(this.deviceNo, acquireExtractRequest.deviceNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, extractType, extractValue, taxNo, taxDeviceMachineNo, deviceNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireExtractRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    extractType: ").append(toIndentedString(extractType)).append("\n");
    sb.append("    extractValue: ").append(toIndentedString(extractValue)).append("\n");
    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
