package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.SubscribeExtractInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireExtractResponse
 */

@JsonInclude(NON_NULL)
public class AcquireExtractResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("subscribeExtractList")
  private List<SubscribeExtractInfo> subscribeExtractList = new ArrayList<>();

  @JsonIgnore
  public AcquireExtractResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 税盘抽取订阅响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "税盘抽取订阅响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireExtractResponse subscribeExtractList(List<SubscribeExtractInfo> subscribeExtractList) {
    this.subscribeExtractList = subscribeExtractList;
    return this;
  }

  public AcquireExtractResponse addSubscribeExtractListItem(SubscribeExtractInfo subscribeExtractListItem) {
    this.subscribeExtractList.add(subscribeExtractListItem);
    return this;
  }

   /**
   * 税盘抽取订阅信息
   * @return subscribeExtractList
  **/

  @Valid

  @ApiModelProperty(value = "税盘抽取订阅信息")
  public List<SubscribeExtractInfo> getSubscribeExtractList() {
    return subscribeExtractList;
  }

  public void setSubscribeExtractList(List<SubscribeExtractInfo> subscribeExtractList) {
    this.subscribeExtractList = subscribeExtractList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireExtractResponse acquireExtractResponse = (AcquireExtractResponse) o;
    return Objects.equals(this.head, acquireExtractResponse.head) &&
        Objects.equals(this.subscribeExtractList, acquireExtractResponse.subscribeExtractList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, subscribeExtractList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireExtractResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    subscribeExtractList: ").append(toIndentedString(subscribeExtractList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
