package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireLicenseResponse
 */

@JsonInclude(NON_NULL)
public class AcquireLicenseResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("licenseUrl")
  private String licenseUrl = null;

  @JsonProperty("licenseData")
  private String licenseData = null;

  @JsonIgnore
  public AcquireLicenseResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 授权文件获取响应，客户端调用时subCode=119 表示加密校验失败
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "授权文件获取响应，客户端调用时subCode=119 表示加密校验失败")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireLicenseResponse licenseUrl(String licenseUrl) {
    this.licenseUrl = licenseUrl;
    return this;
  }

   /**
   * 授权文件下载地址
   * @return licenseUrl
  **/


  @ApiModelProperty(value = "授权文件下载地址")
  public String getLicenseUrl() {
    return licenseUrl;
  }

  public void setLicenseUrl(String licenseUrl) {
    this.licenseUrl = licenseUrl;
  }

  @JsonIgnore
  public AcquireLicenseResponse licenseData(String licenseData) {
    this.licenseData = licenseData;
    return this;
  }

   /**
   * 授权文件二进制Base64编码后的内容，当参数loadFileFlag=true时返回
   * @return licenseData
  **/


  @ApiModelProperty(value = "授权文件二进制Base64编码后的内容，当参数loadFileFlag=true时返回")
  public String getLicenseData() {
    return licenseData;
  }

  public void setLicenseData(String licenseData) {
    this.licenseData = licenseData;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireLicenseResponse acquireLicenseResponse = (AcquireLicenseResponse) o;
    return Objects.equals(this.head, acquireLicenseResponse.head) &&
        Objects.equals(this.licenseUrl, acquireLicenseResponse.licenseUrl) &&
        Objects.equals(this.licenseData, acquireLicenseResponse.licenseData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, licenseUrl, licenseData);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireLicenseResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    licenseUrl: ").append(toIndentedString(licenseUrl)).append("\n");
    sb.append("    licenseData: ").append(toIndentedString(licenseData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
