package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AcquireTokenRequest
 */

@JsonInclude(NON_NULL)
public class AcquireTokenRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("licenseNo")
  private String licenseNo = null;

  @JsonProperty("signature")
  private String signature = null;

  @JsonIgnore
  public AcquireTokenRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AcquireTokenRequest licenseNo(String licenseNo) {
    this.licenseNo = licenseNo;
    return this;
  }

   /**
   * 终端授权文件编号 (必填)
   * @return licenseNo
  **/


  @ApiModelProperty(value = "终端授权文件编号 (必填)")
  public String getLicenseNo() {
    return licenseNo;
  }

  public void setLicenseNo(String licenseNo) {
    this.licenseNo = licenseNo;
  }

  @JsonIgnore
  public AcquireTokenRequest signature(String signature) {
    this.signature = signature;
    return this;
  }

   /**
   * 签名信息 (必填)，HmacSHA1算法加密，规则：{licenseNo}+{到期日期}+{纳税人识别号}
   * @return signature
  **/


  @ApiModelProperty(value = "签名信息 (必填)，HmacSHA1算法加密，规则：{licenseNo}+{到期日期}+{纳税人识别号}")
  public String getSignature() {
    return signature;
  }

  public void setSignature(String signature) {
    this.signature = signature;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AcquireTokenRequest acquireTokenRequest = (AcquireTokenRequest) o;
    return Objects.equals(this.head, acquireTokenRequest.head) &&
        Objects.equals(this.licenseNo, acquireTokenRequest.licenseNo) &&
        Objects.equals(this.signature, acquireTokenRequest.signature);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, licenseNo, signature);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AcquireTokenRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    licenseNo: ").append(toIndentedString(licenseNo)).append("\n");
    sb.append("    signature: ").append(toIndentedString(signature)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
