package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AddDeviceResponse
 */

@JsonInclude(NON_NULL)
public class AddDeviceResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonIgnore
  public AddDeviceResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 设备新增响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "设备新增响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AddDeviceResponse deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id（已废弃，用deviceUn代替）
   * @return deviceId
  **/


  @ApiModelProperty(value = "设备id（已废弃，用deviceUn代替）")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public AddDeviceResponse deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备唯一码
   * @return deviceUn
  **/


  @ApiModelProperty(value = "设备唯一码")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AddDeviceResponse addDeviceResponse = (AddDeviceResponse) o;
    return Objects.equals(this.head, addDeviceResponse.head) &&
        Objects.equals(this.deviceId, addDeviceResponse.deviceId) &&
        Objects.equals(this.deviceUn, addDeviceResponse.deviceUn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceId, deviceUn);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AddDeviceResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
