package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ApplyLicenseRequest
 */

@JsonInclude(NON_NULL)
public class ApplyLicenseRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("expireAt")
  private String expireAt = null;

  @JsonProperty("licenseType")
  private Integer licenseType = null;

  @JsonProperty("applyPolicy")
  private Integer applyPolicy = null;

  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("operateInfo")
  private OperateInfo operateInfo = null;

  @JsonIgnore
  public ApplyLicenseRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public ApplyLicenseRequest expireAt(String expireAt) {
    this.expireAt = expireAt;
    return this;
  }

   /**
   * 到期日期yyyy/MM/dd
   * @return expireAt
  **/


  @ApiModelProperty(value = "到期日期yyyy/MM/dd")
  public String getExpireAt() {
    return expireAt;
  }

  public void setExpireAt(String expireAt) {
    this.expireAt = expireAt;
  }

  @JsonIgnore
  public ApplyLicenseRequest licenseType(Integer licenseType) {
    this.licenseType = licenseType;
    return this;
  }

   /**
   * 1 设备，2 终端
   * @return licenseType
  **/


  @ApiModelProperty(value = "1 设备，2 终端")
  public Integer getLicenseType() {
    return licenseType;
  }

  public void setLicenseType(Integer licenseType) {
    this.licenseType = licenseType;
  }

  @JsonIgnore
  public ApplyLicenseRequest applyPolicy(Integer applyPolicy) {
    this.applyPolicy = applyPolicy;
    return this;
  }

   /**
   * 生成策略 ， 1 初始化生成（当设备/终端不存在授权文件时生成，存在授权文件时跳过） 2 刷新授权文件（新生成一个授权文件）
   * @return applyPolicy
  **/


  @ApiModelProperty(value = "生成策略 ， 1 初始化生成（当设备/终端不存在授权文件时生成，存在授权文件时跳过） 2 刷新授权文件（新生成一个授权文件）")
  public Integer getApplyPolicy() {
    return applyPolicy;
  }

  public void setApplyPolicy(Integer applyPolicy) {
    this.applyPolicy = applyPolicy;
  }

  @JsonIgnore
  public ApplyLicenseRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 申请对象的id
   * @return id
  **/


  @ApiModelProperty(value = "申请对象的id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public ApplyLicenseRequest operateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
    return this;
  }

   /**
   * 操作信息
   * @return operateInfo
  **/

  @Valid

  @ApiModelProperty(value = "操作信息")
  public OperateInfo getOperateInfo() {
    return operateInfo;
  }

  public void setOperateInfo(OperateInfo operateInfo) {
    this.operateInfo = operateInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApplyLicenseRequest applyLicenseRequest = (ApplyLicenseRequest) o;
    return Objects.equals(this.head, applyLicenseRequest.head) &&
        Objects.equals(this.expireAt, applyLicenseRequest.expireAt) &&
        Objects.equals(this.licenseType, applyLicenseRequest.licenseType) &&
        Objects.equals(this.applyPolicy, applyLicenseRequest.applyPolicy) &&
        Objects.equals(this.id, applyLicenseRequest.id) &&
        Objects.equals(this.operateInfo, applyLicenseRequest.operateInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, expireAt, licenseType, applyPolicy, id, operateInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApplyLicenseRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    expireAt: ").append(toIndentedString(expireAt)).append("\n");
    sb.append("    licenseType: ").append(toIndentedString(licenseType)).append("\n");
    sb.append("    applyPolicy: ").append(toIndentedString(applyPolicy)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    operateInfo: ").append(toIndentedString(operateInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
