package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * AssignQueueRequest
 */

@JsonInclude(NON_NULL)
public class AssignQueueRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("account")
  private String account = null;

  @JsonProperty("accountType")
  private String accountType = "mi";

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonIgnore
  public AssignQueueRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public AssignQueueRequest account(String account) {
    this.account = account;
    return this;
  }

   /**
   * 账号
   * @return account
  **/


  @ApiModelProperty(value = "账号")
  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  @JsonIgnore
  public AssignQueueRequest accountType(String accountType) {
    this.accountType = accountType;
    return this;
  }

   /**
   * 账号类型，mi：mi账号 un：un账号 el：el账号
   * @return accountType
  **/


  @ApiModelProperty(value = "账号类型，mi：mi账号 un：un账号 el：el账号")
  public String getAccountType() {
    return accountType;
  }

  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }

  @JsonIgnore
  public AssignQueueRequest deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号
   * @return deviceNo
  **/


  @ApiModelProperty(value = "设备编号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AssignQueueRequest assignQueueRequest = (AssignQueueRequest) o;
    return Objects.equals(this.head, assignQueueRequest.head) &&
        Objects.equals(this.account, assignQueueRequest.account) &&
        Objects.equals(this.accountType, assignQueueRequest.accountType) &&
        Objects.equals(this.deviceNo, assignQueueRequest.deviceNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, account, accountType, deviceNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AssignQueueRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
