package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.CAInfo;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * DeviceCAQueryResponse
 */

@JsonInclude(NON_NULL)
public class DeviceCAQueryResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("CAInfos")
  private List<CAInfo> caInfos = new ArrayList<>();

  @JsonIgnore
  public DeviceCAQueryResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询设备证书响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询设备证书响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public DeviceCAQueryResponse caInfos(List<CAInfo> caInfos) {
    this.caInfos = caInfos;
    return this;
  }

  public DeviceCAQueryResponse addCaInfosItem(CAInfo caInfosItem) {
    this.caInfos.add(caInfosItem);
    return this;
  }

   /**
   * 证书信息
   * @return caInfos
  **/

  @Valid

  @ApiModelProperty(value = "证书信息")
  public List<CAInfo> getCaInfos() {
    return caInfos;
  }

  public void setCaInfos(List<CAInfo> caInfos) {
    this.caInfos = caInfos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeviceCAQueryResponse deviceCAQueryResponse = (DeviceCAQueryResponse) o;
    return Objects.equals(this.head, deviceCAQueryResponse.head) &&
        Objects.equals(this.caInfos, deviceCAQueryResponse.caInfos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, caInfos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeviceCAQueryResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    caInfos: ").append(toIndentedString(caInfos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
