package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 心跳详细数据
 */
@ApiModel(description = "心跳详细数据")

@JsonInclude(NON_NULL)
public class HeartBeatDetail implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("makeInvoiceFlag")
  private Boolean makeInvoiceFlag = null;

  @JsonProperty("discardInvoiceFlag")
  private Boolean discardInvoiceFlag = null;

  @JsonProperty("taxPrintFlag")
  private Boolean taxPrintFlag = null;

  @JsonProperty("normalPrintFlag")
  private Boolean normalPrintFlag = null;

  @JsonProperty("queryNextInvoiceFlag")
  private Boolean queryNextInvoiceFlag = null;

  @JsonProperty("mqEnableFlag")
  private Boolean mqEnableFlag = null;

  @JsonProperty("sqsDirectFlag")
  private Boolean sqsDirectFlag = null;

  @JsonProperty("assistantFlag")
  private Boolean assistantFlag = null;

  @JsonProperty("discardEmptyInvoiceFlag")
  private Boolean discardEmptyInvoiceFlag = null;

  @JsonProperty("customCommodityCode")
  private Boolean customCommodityCode = null;

  @JsonProperty("caSignFlag")
  private Boolean caSignFlag = null;

  @JsonProperty("applyRedNotificationFlag")
  private Boolean applyRedNotificationFlag = null;

  @JsonProperty("vehicleTaxPrintFlag")
  private Boolean vehicleTaxPrintFlag = null;

  @JsonProperty("trusteeshipFlag")
  private Boolean trusteeshipFlag = null;

  @JsonProperty("sqsUnFlag")
  private Boolean sqsUnFlag = null;

  @JsonProperty("sqsOriginAccountFlag")
  private Boolean sqsOriginAccountFlag = null;

  @JsonProperty("sqsOriginAccountEnableFlag")
  private Boolean sqsOriginAccountEnableFlag = null;

  @JsonProperty("mqOriginAccountEnableFlag")
  private Boolean mqOriginAccountEnableFlag = null;

  @JsonIgnore
  public HeartBeatDetail makeInvoiceFlag(Boolean makeInvoiceFlag) {
    this.makeInvoiceFlag = makeInvoiceFlag;
    return this;
  }

   /**
   * 开票(含仅开具、开具并打印、红冲)是否可用，true:可用 false：不可用 null：未知
   * @return makeInvoiceFlag
  **/


  @ApiModelProperty(value = "开票(含仅开具、开具并打印、红冲)是否可用，true:可用 false：不可用 null：未知")
  public Boolean MakeInvoiceFlag() {
    return makeInvoiceFlag;
  }

  public void setMakeInvoiceFlag(Boolean makeInvoiceFlag) {
    this.makeInvoiceFlag = makeInvoiceFlag;
  }

  @JsonIgnore
  public HeartBeatDetail discardInvoiceFlag(Boolean discardInvoiceFlag) {
    this.discardInvoiceFlag = discardInvoiceFlag;
    return this;
  }

   /**
   * 发票作废是否可用，true:可用 false：不可用 null：未知
   * @return discardInvoiceFlag
  **/


  @ApiModelProperty(value = "发票作废是否可用，true:可用 false：不可用 null：未知")
  public Boolean DiscardInvoiceFlag() {
    return discardInvoiceFlag;
  }

  public void setDiscardInvoiceFlag(Boolean discardInvoiceFlag) {
    this.discardInvoiceFlag = discardInvoiceFlag;
  }

  @JsonIgnore
  public HeartBeatDetail taxPrintFlag(Boolean taxPrintFlag) {
    this.taxPrintFlag = taxPrintFlag;
    return this;
  }

   /**
   * 税控打印是否可用，true:可用 false：不可用 null：未知
   * @return taxPrintFlag
  **/


  @ApiModelProperty(value = "税控打印是否可用，true:可用 false：不可用 null：未知")
  public Boolean TaxPrintFlag() {
    return taxPrintFlag;
  }

  public void setTaxPrintFlag(Boolean taxPrintFlag) {
    this.taxPrintFlag = taxPrintFlag;
  }

  @JsonIgnore
  public HeartBeatDetail normalPrintFlag(Boolean normalPrintFlag) {
    this.normalPrintFlag = normalPrintFlag;
    return this;
  }

   /**
   * 全量打印是否可用，true:可用 false：不可用 null：未知
   * @return normalPrintFlag
  **/


  @ApiModelProperty(value = "全量打印是否可用，true:可用 false：不可用 null：未知")
  public Boolean NormalPrintFlag() {
    return normalPrintFlag;
  }

  public void setNormalPrintFlag(Boolean normalPrintFlag) {
    this.normalPrintFlag = normalPrintFlag;
  }

  @JsonIgnore
  public HeartBeatDetail queryNextInvoiceFlag(Boolean queryNextInvoiceFlag) {
    this.queryNextInvoiceFlag = queryNextInvoiceFlag;
    return this;
  }

   /**
   * 查询下一发票号码是否可用，true:可用 false：不可用 null：未知
   * @return queryNextInvoiceFlag
  **/


  @ApiModelProperty(value = "查询下一发票号码是否可用，true:可用 false：不可用 null：未知")
  public Boolean QueryNextInvoiceFlag() {
    return queryNextInvoiceFlag;
  }

  public void setQueryNextInvoiceFlag(Boolean queryNextInvoiceFlag) {
    this.queryNextInvoiceFlag = queryNextInvoiceFlag;
  }

  @JsonIgnore
  public HeartBeatDetail mqEnableFlag(Boolean mqEnableFlag) {
    this.mqEnableFlag = mqEnableFlag;
    return this;
  }

   /**
   * MQ是否可用，true:可用 false：不可用 null：未知
   * @return mqEnableFlag
  **/


  @ApiModelProperty(value = "MQ是否可用，true:可用 false：不可用 null：未知")
  public Boolean MqEnableFlag() {
    return mqEnableFlag;
  }

  public void setMqEnableFlag(Boolean mqEnableFlag) {
    this.mqEnableFlag = mqEnableFlag;
  }

  @JsonIgnore
  public HeartBeatDetail sqsDirectFlag(Boolean sqsDirectFlag) {
    this.sqsDirectFlag = sqsDirectFlag;
    return this;
  }

   /**
   * 直连SQS是否可用，true:可用 false：不可用 null：未知
   * @return sqsDirectFlag
  **/


  @ApiModelProperty(value = "直连SQS是否可用，true:可用 false：不可用 null：未知")
  public Boolean SqsDirectFlag() {
    return sqsDirectFlag;
  }

  public void setSqsDirectFlag(Boolean sqsDirectFlag) {
    this.sqsDirectFlag = sqsDirectFlag;
  }

  @JsonIgnore
  public HeartBeatDetail assistantFlag(Boolean assistantFlag) {
    this.assistantFlag = assistantFlag;
    return this;
  }

   /**
   * 辅助是否可用，true:可用 false：不可用 null：未知
   * @return assistantFlag
  **/


  @ApiModelProperty(value = "辅助是否可用，true:可用 false：不可用 null：未知")
  public Boolean AssistantFlag() {
    return assistantFlag;
  }

  public void setAssistantFlag(Boolean assistantFlag) {
    this.assistantFlag = assistantFlag;
  }

  @JsonIgnore
  public HeartBeatDetail discardEmptyInvoiceFlag(Boolean discardEmptyInvoiceFlag) {
    this.discardEmptyInvoiceFlag = discardEmptyInvoiceFlag;
    return this;
  }

   /**
   * 是否支持空白发票作废，true:可用 false：不可用 null：未知
   * @return discardEmptyInvoiceFlag
  **/


  @ApiModelProperty(value = "是否支持空白发票作废，true:可用 false：不可用 null：未知")
  public Boolean DiscardEmptyInvoiceFlag() {
    return discardEmptyInvoiceFlag;
  }

  public void setDiscardEmptyInvoiceFlag(Boolean discardEmptyInvoiceFlag) {
    this.discardEmptyInvoiceFlag = discardEmptyInvoiceFlag;
  }

  @JsonIgnore
  public HeartBeatDetail customCommodityCode(Boolean customCommodityCode) {
    this.customCommodityCode = customCommodityCode;
    return this;
  }

   /**
   * 是否支持自定义商品代码，true:可用 false：不可用 null：未知
   * @return customCommodityCode
  **/


  @ApiModelProperty(value = "是否支持自定义商品代码，true:可用 false：不可用 null：未知")
  public Boolean CustomCommodityCode() {
    return customCommodityCode;
  }

  public void setCustomCommodityCode(Boolean customCommodityCode) {
    this.customCommodityCode = customCommodityCode;
  }

  @JsonIgnore
  public HeartBeatDetail caSignFlag(Boolean caSignFlag) {
    this.caSignFlag = caSignFlag;
    return this;
  }

   /**
   * 是否支持CA签名，true:可用 false：不可用 null：未知
   * @return caSignFlag
  **/


  @ApiModelProperty(value = "是否支持CA签名，true:可用 false：不可用 null：未知")
  public Boolean CaSignFlag() {
    return caSignFlag;
  }

  public void setCaSignFlag(Boolean caSignFlag) {
    this.caSignFlag = caSignFlag;
  }

  @JsonIgnore
  public HeartBeatDetail applyRedNotificationFlag(Boolean applyRedNotificationFlag) {
    this.applyRedNotificationFlag = applyRedNotificationFlag;
    return this;
  }

   /**
   * 红字信息表申请是否可用，true:可用 false：不可用 null：未知
   * @return applyRedNotificationFlag
  **/


  @ApiModelProperty(value = "红字信息表申请是否可用，true:可用 false：不可用 null：未知")
  public Boolean ApplyRedNotificationFlag() {
    return applyRedNotificationFlag;
  }

  public void setApplyRedNotificationFlag(Boolean applyRedNotificationFlag) {
    this.applyRedNotificationFlag = applyRedNotificationFlag;
  }

  @JsonIgnore
  public HeartBeatDetail vehicleTaxPrintFlag(Boolean vehicleTaxPrintFlag) {
    this.vehicleTaxPrintFlag = vehicleTaxPrintFlag;
    return this;
  }

   /**
   * 是否支持车购税打印，true:可用 false：不可用 null：未知
   * @return vehicleTaxPrintFlag
  **/


  @ApiModelProperty(value = "是否支持车购税打印，true:可用 false：不可用 null：未知")
  public Boolean VehicleTaxPrintFlag() {
    return vehicleTaxPrintFlag;
  }

  public void setVehicleTaxPrintFlag(Boolean vehicleTaxPrintFlag) {
    this.vehicleTaxPrintFlag = vehicleTaxPrintFlag;
  }

  @JsonIgnore
  public HeartBeatDetail trusteeshipFlag(Boolean trusteeshipFlag) {
    this.trusteeshipFlag = trusteeshipFlag;
    return this;
  }

   /**
   * 是否托管客户端，true:可用 false：不可用 null：未知
   * @return trusteeshipFlag
  **/


  @ApiModelProperty(value = "是否托管客户端，true:可用 false：不可用 null：未知")
  public Boolean TrusteeshipFlag() {
    return trusteeshipFlag;
  }

  public void setTrusteeshipFlag(Boolean trusteeshipFlag) {
    this.trusteeshipFlag = trusteeshipFlag;
  }

  @JsonIgnore
  public HeartBeatDetail sqsUnFlag(Boolean sqsUnFlag) {
    this.sqsUnFlag = sqsUnFlag;
    return this;
  }

   /**
   * UN SQS是否启用，true:可用 false：不可用 null：未知
   * @return sqsUnFlag
  **/


  @ApiModelProperty(value = "UN SQS是否启用，true:可用 false：不可用 null：未知")
  public Boolean SqsUnFlag() {
    return sqsUnFlag;
  }

  public void setSqsUnFlag(Boolean sqsUnFlag) {
    this.sqsUnFlag = sqsUnFlag;
  }

  @JsonIgnore
  public HeartBeatDetail sqsOriginAccountFlag(Boolean sqsOriginAccountFlag) {
    this.sqsOriginAccountFlag = sqsOriginAccountFlag;
    return this;
  }

   /**
   * 底账SQS是否启用，true:可用 false：不可用 null：未知
   * @return sqsOriginAccountFlag
  **/


  @ApiModelProperty(value = "底账SQS是否启用，true:可用 false：不可用 null：未知")
  public Boolean SqsOriginAccountFlag() {
    return sqsOriginAccountFlag;
  }

  public void setSqsOriginAccountFlag(Boolean sqsOriginAccountFlag) {
    this.sqsOriginAccountFlag = sqsOriginAccountFlag;
  }

  @JsonIgnore
  public HeartBeatDetail sqsOriginAccountEnableFlag(Boolean sqsOriginAccountEnableFlag) {
    this.sqsOriginAccountEnableFlag = sqsOriginAccountEnableFlag;
    return this;
  }

   /**
   * 底账单机设备是否正常(服务器切换设备是否正常)，true:可用 false：不可用 null：未知
   * @return sqsOriginAccountEnableFlag
  **/


  @ApiModelProperty(value = "底账单机设备是否正常(服务器切换设备是否正常)，true:可用 false：不可用 null：未知")
  public Boolean SqsOriginAccountEnableFlag() {
    return sqsOriginAccountEnableFlag;
  }

  public void setSqsOriginAccountEnableFlag(Boolean sqsOriginAccountEnableFlag) {
    this.sqsOriginAccountEnableFlag = sqsOriginAccountEnableFlag;
  }

  @JsonIgnore
  public HeartBeatDetail mqOriginAccountEnableFlag(Boolean mqOriginAccountEnableFlag) {
    this.mqOriginAccountEnableFlag = mqOriginAccountEnableFlag;
    return this;
  }

   /**
   * 底账AMQ是否启用，true:可用 false：不可用 null：未知
   * @return mqOriginAccountEnableFlag
  **/


  @ApiModelProperty(value = "底账AMQ是否启用，true:可用 false：不可用 null：未知")
  public Boolean MqOriginAccountEnableFlag() {
    return mqOriginAccountEnableFlag;
  }

  public void setMqOriginAccountEnableFlag(Boolean mqOriginAccountEnableFlag) {
    this.mqOriginAccountEnableFlag = mqOriginAccountEnableFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HeartBeatDetail heartBeatDetail = (HeartBeatDetail) o;
    return Objects.equals(this.makeInvoiceFlag, heartBeatDetail.makeInvoiceFlag) &&
        Objects.equals(this.discardInvoiceFlag, heartBeatDetail.discardInvoiceFlag) &&
        Objects.equals(this.taxPrintFlag, heartBeatDetail.taxPrintFlag) &&
        Objects.equals(this.normalPrintFlag, heartBeatDetail.normalPrintFlag) &&
        Objects.equals(this.queryNextInvoiceFlag, heartBeatDetail.queryNextInvoiceFlag) &&
        Objects.equals(this.mqEnableFlag, heartBeatDetail.mqEnableFlag) &&
        Objects.equals(this.sqsDirectFlag, heartBeatDetail.sqsDirectFlag) &&
        Objects.equals(this.assistantFlag, heartBeatDetail.assistantFlag) &&
        Objects.equals(this.discardEmptyInvoiceFlag, heartBeatDetail.discardEmptyInvoiceFlag) &&
        Objects.equals(this.customCommodityCode, heartBeatDetail.customCommodityCode) &&
        Objects.equals(this.caSignFlag, heartBeatDetail.caSignFlag) &&
        Objects.equals(this.applyRedNotificationFlag, heartBeatDetail.applyRedNotificationFlag) &&
        Objects.equals(this.vehicleTaxPrintFlag, heartBeatDetail.vehicleTaxPrintFlag) &&
        Objects.equals(this.trusteeshipFlag, heartBeatDetail.trusteeshipFlag) &&
        Objects.equals(this.sqsUnFlag, heartBeatDetail.sqsUnFlag) &&
        Objects.equals(this.sqsOriginAccountFlag, heartBeatDetail.sqsOriginAccountFlag) &&
        Objects.equals(this.sqsOriginAccountEnableFlag, heartBeatDetail.sqsOriginAccountEnableFlag) &&
        Objects.equals(this.mqOriginAccountEnableFlag, heartBeatDetail.mqOriginAccountEnableFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(makeInvoiceFlag, discardInvoiceFlag, taxPrintFlag, normalPrintFlag, queryNextInvoiceFlag, mqEnableFlag, sqsDirectFlag, assistantFlag, discardEmptyInvoiceFlag, customCommodityCode, caSignFlag, applyRedNotificationFlag, vehicleTaxPrintFlag, trusteeshipFlag, sqsUnFlag, sqsOriginAccountFlag, sqsOriginAccountEnableFlag, mqOriginAccountEnableFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HeartBeatDetail {\n");
    
    sb.append("    makeInvoiceFlag: ").append(toIndentedString(makeInvoiceFlag)).append("\n");
    sb.append("    discardInvoiceFlag: ").append(toIndentedString(discardInvoiceFlag)).append("\n");
    sb.append("    taxPrintFlag: ").append(toIndentedString(taxPrintFlag)).append("\n");
    sb.append("    normalPrintFlag: ").append(toIndentedString(normalPrintFlag)).append("\n");
    sb.append("    queryNextInvoiceFlag: ").append(toIndentedString(queryNextInvoiceFlag)).append("\n");
    sb.append("    mqEnableFlag: ").append(toIndentedString(mqEnableFlag)).append("\n");
    sb.append("    sqsDirectFlag: ").append(toIndentedString(sqsDirectFlag)).append("\n");
    sb.append("    assistantFlag: ").append(toIndentedString(assistantFlag)).append("\n");
    sb.append("    discardEmptyInvoiceFlag: ").append(toIndentedString(discardEmptyInvoiceFlag)).append("\n");
    sb.append("    customCommodityCode: ").append(toIndentedString(customCommodityCode)).append("\n");
    sb.append("    caSignFlag: ").append(toIndentedString(caSignFlag)).append("\n");
    sb.append("    applyRedNotificationFlag: ").append(toIndentedString(applyRedNotificationFlag)).append("\n");
    sb.append("    vehicleTaxPrintFlag: ").append(toIndentedString(vehicleTaxPrintFlag)).append("\n");
    sb.append("    trusteeshipFlag: ").append(toIndentedString(trusteeshipFlag)).append("\n");
    sb.append("    sqsUnFlag: ").append(toIndentedString(sqsUnFlag)).append("\n");
    sb.append("    sqsOriginAccountFlag: ").append(toIndentedString(sqsOriginAccountFlag)).append("\n");
    sb.append("    sqsOriginAccountEnableFlag: ").append(toIndentedString(sqsOriginAccountEnableFlag)).append("\n");
    sb.append("    mqOriginAccountEnableFlag: ").append(toIndentedString(mqOriginAccountEnableFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
