package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceDeposeResultResponse
 */

@JsonInclude(NON_NULL)
public class InvoiceDeposeResultResponse implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("deposeDate")
  private String deposeDate = null;

  @JsonIgnore
  public InvoiceDeposeResultResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准响应头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准响应头信息")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceDeposeResultResponse requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public InvoiceDeposeResultResponse invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/


  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoiceDeposeResultResponse invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/


  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public InvoiceDeposeResultResponse deposeDate(String deposeDate) {
    this.deposeDate = deposeDate;
    return this;
  }

   /**
   * 作废日期
   * @return deposeDate
  **/


  @ApiModelProperty(value = "作废日期")
  public String getDeposeDate() {
    return deposeDate;
  }

  public void setDeposeDate(String deposeDate) {
    this.deposeDate = deposeDate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceDeposeResultResponse invoiceDeposeResultResponse = (InvoiceDeposeResultResponse) o;
    return Objects.equals(this.head, invoiceDeposeResultResponse.head) &&
        Objects.equals(this.requestSerialNo, invoiceDeposeResultResponse.requestSerialNo) &&
        Objects.equals(this.invoiceCode, invoiceDeposeResultResponse.invoiceCode) &&
        Objects.equals(this.invoiceNo, invoiceDeposeResultResponse.invoiceNo) &&
        Objects.equals(this.deposeDate, invoiceDeposeResultResponse.deposeDate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, requestSerialNo, invoiceCode, invoiceNo, deposeDate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceDeposeResultResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    deposeDate: ").append(toIndentedString(deposeDate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
