package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.ClientInvoiceStockQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceStockForThreePointFiveRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceStockForThreePointFiveRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("queryList")
  private List<ClientInvoiceStockQueryInfo> queryList = new ArrayList<>();

  @JsonIgnore
  public InvoiceStockForThreePointFiveRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceStockForThreePointFiveRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型（客户端支持【c、s、ce、ju、v】s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（客户端支持【c、s、ce、ju、v】s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public InvoiceStockForThreePointFiveRequest queryList(List<ClientInvoiceStockQueryInfo> queryList) {
    this.queryList = queryList;
    return this;
  }

  public InvoiceStockForThreePointFiveRequest addQueryListItem(ClientInvoiceStockQueryInfo queryListItem) {
    this.queryList.add(queryListItem);
    return this;
  }

   /**
   * 查询信息
   * @return queryList
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "查询信息")
  public List<ClientInvoiceStockQueryInfo> getQueryList() {
    return queryList;
  }

  public void setQueryList(List<ClientInvoiceStockQueryInfo> queryList) {
    this.queryList = queryList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceStockForThreePointFiveRequest invoiceStockForThreePointFiveRequest = (InvoiceStockForThreePointFiveRequest) o;
    return Objects.equals(this.head, invoiceStockForThreePointFiveRequest.head) &&
        Objects.equals(this.invoiceType, invoiceStockForThreePointFiveRequest.invoiceType) &&
        Objects.equals(this.queryList, invoiceStockForThreePointFiveRequest.queryList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, invoiceType, queryList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceStockForThreePointFiveRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    queryList: ").append(toIndentedString(queryList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
