package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * InvoiceStockRequest
 */

@JsonInclude(NON_NULL)
public class InvoiceStockRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("deviceIds")
  private List<Long> deviceIds = new ArrayList<>();

  @JsonProperty("deviceUns")
  private List<String> deviceUns = new ArrayList<>();

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonIgnore
  public InvoiceStockRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public InvoiceStockRequest deviceIds(List<Long> deviceIds) {
    this.deviceIds = deviceIds;
    return this;
  }

  public InvoiceStockRequest addDeviceIdsItem(Long deviceIdsItem) {
    this.deviceIds.add(deviceIdsItem);
    return this;
  }

   /**
   * 设备id（一次查询最多支持1个设备ID）【已废弃，用deviceUn代替】
   * @return deviceIds
  **/


  @ApiModelProperty(value = "设备id（一次查询最多支持1个设备ID）【已废弃，用deviceUn代替】")
  public List<Long> getDeviceIds() {
    return deviceIds;
  }

  public void setDeviceIds(List<Long> deviceIds) {
    this.deviceIds = deviceIds;
  }

  @JsonIgnore
  public InvoiceStockRequest deviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
    return this;
  }

  public InvoiceStockRequest addDeviceUnsItem(String deviceUnsItem) {
    this.deviceUns.add(deviceUnsItem);
    return this;
  }

   /**
   * 设备唯一码（一次查询最多支持1个设备唯一码）
   * @return deviceUns
  **/


  @ApiModelProperty(value = "设备唯一码（一次查询最多支持1个设备唯一码）")
  public List<String> getDeviceUns() {
    return deviceUns;
  }

  public void setDeviceUns(List<String> deviceUns) {
    this.deviceUns = deviceUns;
  }

  @JsonIgnore
  public InvoiceStockRequest invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型（客户端支持【c、s、ce、ju、v】服务器端支持【c、s、ce】s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票
   * @return invoiceType
  **/


  @ApiModelProperty(value = "发票类型（客户端支持【c、s、ce、ju、v】服务器端支持【c、s、ce】s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceStockRequest invoiceStockRequest = (InvoiceStockRequest) o;
    return Objects.equals(this.head, invoiceStockRequest.head) &&
        Objects.equals(this.deviceIds, invoiceStockRequest.deviceIds) &&
        Objects.equals(this.deviceUns, invoiceStockRequest.deviceUns) &&
        Objects.equals(this.invoiceType, invoiceStockRequest.invoiceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, deviceIds, deviceUns, invoiceType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceStockRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    deviceIds: ").append(toIndentedString(deviceIds)).append("\n");
    sb.append("    deviceUns: ").append(toIndentedString(deviceUns)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
