package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.HeartBeatClientInfo;
import com.xforceplus.micro.tax.device.contract.model.HeartBeatDetail;
import com.xforceplus.micro.tax.device.contract.model.ResponseHead;
import com.xforceplus.micro.tax.device.contract.model.TaxDiscInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * QueryQueueStatusResponse1
 */

@JsonInclude(NON_NULL)
public class QueryQueueStatusResponse1 implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("queueName")
  private String queueName = null;

  @JsonProperty("priorityQueueName")
  private String priorityQueueName = null;

  @JsonProperty("directOnlineFlag")
  private Boolean directOnlineFlag = false;

  @JsonProperty("amqDirectOnlineFlag")
  private Boolean amqDirectOnlineFlag = false;

  @JsonProperty("sqsDrawOnlineFlag")
  private Boolean sqsDrawOnlineFlag = false;

  @JsonProperty("sqsOriginAccountOnlineFlag")
  private Boolean sqsOriginAccountOnlineFlag = false;

  @JsonProperty("trusteeshipFlag")
  private Boolean trusteeshipFlag = null;

  @JsonProperty("amqQueueOnlineFlag")
  private Boolean amqQueueOnlineFlag = null;

  @JsonProperty("clientInfo")
  private HeartBeatClientInfo clientInfo = null;

  @JsonProperty("heartBeatDetail")
  private HeartBeatDetail heartBeatDetail = null;

  @JsonProperty("taxDiscInfo")
  private TaxDiscInfo taxDiscInfo = null;

  @JsonProperty("hasStockInvoiceType")
  private List<String> hasStockInvoiceType = new ArrayList<>();

  @JsonProperty("sourceFrom")
  private String sourceFrom = null;

  @JsonProperty("refinedOilQualificationFlag")
  private Boolean refinedOilQualificationFlag = null;

  @JsonIgnore
  public QueryQueueStatusResponse1 head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 查询队列状态响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "查询队列状态响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 queueName(String queueName) {
    this.queueName = queueName;
    return this;
  }

   /**
   * SQS队列名称
   * @return queueName
  **/


  @ApiModelProperty(value = "SQS队列名称")
  public String getQueueName() {
    return queueName;
  }

  public void setQueueName(String queueName) {
    this.queueName = queueName;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 priorityQueueName(String priorityQueueName) {
    this.priorityQueueName = priorityQueueName;
    return this;
  }

   /**
   * SQS优先队列名称
   * @return priorityQueueName
  **/


  @ApiModelProperty(value = "SQS优先队列名称")
  public String getPriorityQueueName() {
    return priorityQueueName;
  }

  public void setPriorityQueueName(String priorityQueueName) {
    this.priorityQueueName = priorityQueueName;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 directOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
    return this;
  }

   /**
   * SQS直连在线标志,true:在线 false:不在线
   * @return directOnlineFlag
  **/


  @ApiModelProperty(value = "SQS直连在线标志,true:在线 false:不在线")
  public Boolean DirectOnlineFlag() {
    return directOnlineFlag;
  }

  public void setDirectOnlineFlag(Boolean directOnlineFlag) {
    this.directOnlineFlag = directOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 amqDirectOnlineFlag(Boolean amqDirectOnlineFlag) {
    this.amqDirectOnlineFlag = amqDirectOnlineFlag;
    return this;
  }

   /**
   * 【基于心跳】amq直连在线标志,true:在线 false:不在线
   * @return amqDirectOnlineFlag
  **/


  @ApiModelProperty(value = "【基于心跳】amq直连在线标志,true:在线 false:不在线")
  public Boolean AmqDirectOnlineFlag() {
    return amqDirectOnlineFlag;
  }

  public void setAmqDirectOnlineFlag(Boolean amqDirectOnlineFlag) {
    this.amqDirectOnlineFlag = amqDirectOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 sqsDrawOnlineFlag(Boolean sqsDrawOnlineFlag) {
    this.sqsDrawOnlineFlag = sqsDrawOnlineFlag;
    return this;
  }

   /**
   * SQS抽取在线标志,true:在线 false:不在线
   * @return sqsDrawOnlineFlag
  **/


  @ApiModelProperty(value = "SQS抽取在线标志,true:在线 false:不在线")
  public Boolean SqsDrawOnlineFlag() {
    return sqsDrawOnlineFlag;
  }

  public void setSqsDrawOnlineFlag(Boolean sqsDrawOnlineFlag) {
    this.sqsDrawOnlineFlag = sqsDrawOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 sqsOriginAccountOnlineFlag(Boolean sqsOriginAccountOnlineFlag) {
    this.sqsOriginAccountOnlineFlag = sqsOriginAccountOnlineFlag;
    return this;
  }

   /**
   * SQS抵账在线标志,true:在线 false:不在线
   * @return sqsOriginAccountOnlineFlag
  **/


  @ApiModelProperty(value = "SQS抵账在线标志,true:在线 false:不在线")
  public Boolean SqsOriginAccountOnlineFlag() {
    return sqsOriginAccountOnlineFlag;
  }

  public void setSqsOriginAccountOnlineFlag(Boolean sqsOriginAccountOnlineFlag) {
    this.sqsOriginAccountOnlineFlag = sqsOriginAccountOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 trusteeshipFlag(Boolean trusteeshipFlag) {
    this.trusteeshipFlag = trusteeshipFlag;
    return this;
  }

   /**
   * 托管标志,true：托管 false：非托管
   * @return trusteeshipFlag
  **/


  @ApiModelProperty(value = "托管标志,true：托管 false：非托管")
  public Boolean TrusteeshipFlag() {
    return trusteeshipFlag;
  }

  public void setTrusteeshipFlag(Boolean trusteeshipFlag) {
    this.trusteeshipFlag = trusteeshipFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 amqQueueOnlineFlag(Boolean amqQueueOnlineFlag) {
    this.amqQueueOnlineFlag = amqQueueOnlineFlag;
    return this;
  }

   /**
   * MI对应的队列在线标志,true：在线 false：不在线，参数中传入：acquireQueueStatusInAMQ=true时返回
   * @return amqQueueOnlineFlag
  **/


  @ApiModelProperty(value = "MI对应的队列在线标志,true：在线 false：不在线，参数中传入：acquireQueueStatusInAMQ=true时返回")
  public Boolean AmqQueueOnlineFlag() {
    return amqQueueOnlineFlag;
  }

  public void setAmqQueueOnlineFlag(Boolean amqQueueOnlineFlag) {
    this.amqQueueOnlineFlag = amqQueueOnlineFlag;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 clientInfo(HeartBeatClientInfo clientInfo) {
    this.clientInfo = clientInfo;
    return this;
  }

   /**
   * 客户端信息
   * @return clientInfo
  **/

  @Valid

  @ApiModelProperty(value = "客户端信息")
  public HeartBeatClientInfo getClientInfo() {
    return clientInfo;
  }

  public void setClientInfo(HeartBeatClientInfo clientInfo) {
    this.clientInfo = clientInfo;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 heartBeatDetail(HeartBeatDetail heartBeatDetail) {
    this.heartBeatDetail = heartBeatDetail;
    return this;
  }

   /**
   * 心跳数据详细信息，仅当数据来源为正常心跳时返回
   * @return heartBeatDetail
  **/

  @Valid

  @ApiModelProperty(value = "心跳数据详细信息，仅当数据来源为正常心跳时返回")
  public HeartBeatDetail getHeartBeatDetail() {
    return heartBeatDetail;
  }

  public void setHeartBeatDetail(HeartBeatDetail heartBeatDetail) {
    this.heartBeatDetail = heartBeatDetail;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 taxDiscInfo(TaxDiscInfo taxDiscInfo) {
    this.taxDiscInfo = taxDiscInfo;
    return this;
  }

   /**
   * 税盘信息
   * @return taxDiscInfo
  **/

  @Valid

  @ApiModelProperty(value = "税盘信息")
  public TaxDiscInfo getTaxDiscInfo() {
    return taxDiscInfo;
  }

  public void setTaxDiscInfo(TaxDiscInfo taxDiscInfo) {
    this.taxDiscInfo = taxDiscInfo;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 hasStockInvoiceType(List<String> hasStockInvoiceType) {
    this.hasStockInvoiceType = hasStockInvoiceType;
    return this;
  }

  public QueryQueueStatusResponse1 addHasStockInvoiceTypeItem(String hasStockInvoiceTypeItem) {
    this.hasStockInvoiceType.add(hasStockInvoiceTypeItem);
    return this;
  }

   /**
   * 有库存的发票类型,仅当查询库存且directOnlineFlag=true时，有值返回（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，vs:二手机动车发票）
   * @return hasStockInvoiceType
  **/


  @ApiModelProperty(value = "有库存的发票类型,仅当查询库存且directOnlineFlag=true时，有值返回（s:增值税专票，c:增值税普票，ce:电子发票，ju:增值税卷票，v:机动车发票，vs:二手机动车发票）")
  public List<String> getHasStockInvoiceType() {
    return hasStockInvoiceType;
  }

  public void setHasStockInvoiceType(List<String> hasStockInvoiceType) {
    this.hasStockInvoiceType = hasStockInvoiceType;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 sourceFrom(String sourceFrom) {
    this.sourceFrom = sourceFrom;
    return this;
  }

   /**
   * 数据来源，heartBeat-normal:正常的心跳，heartBeat-expired:过期心跳，none:无
   * @return sourceFrom
  **/


  @ApiModelProperty(value = "数据来源，heartBeat-normal:正常的心跳，heartBeat-expired:过期心跳，none:无")
  public String getSourceFrom() {
    return sourceFrom;
  }

  public void setSourceFrom(String sourceFrom) {
    this.sourceFrom = sourceFrom;
  }

  @JsonIgnore
  public QueryQueueStatusResponse1 refinedOilQualificationFlag(Boolean refinedOilQualificationFlag) {
    this.refinedOilQualificationFlag = refinedOilQualificationFlag;
    return this;
  }

   /**
   * 成品油资质标志,true：具有成品油开票资质 false：不具有成品油开票资质
   * @return refinedOilQualificationFlag
  **/


  @ApiModelProperty(value = "成品油资质标志,true：具有成品油开票资质 false：不具有成品油开票资质")
  public Boolean RefinedOilQualificationFlag() {
    return refinedOilQualificationFlag;
  }

  public void setRefinedOilQualificationFlag(Boolean refinedOilQualificationFlag) {
    this.refinedOilQualificationFlag = refinedOilQualificationFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryQueueStatusResponse1 queryQueueStatusResponse1 = (QueryQueueStatusResponse1) o;
    return Objects.equals(this.head, queryQueueStatusResponse1.head) &&
        Objects.equals(this.queueName, queryQueueStatusResponse1.queueName) &&
        Objects.equals(this.priorityQueueName, queryQueueStatusResponse1.priorityQueueName) &&
        Objects.equals(this.directOnlineFlag, queryQueueStatusResponse1.directOnlineFlag) &&
        Objects.equals(this.amqDirectOnlineFlag, queryQueueStatusResponse1.amqDirectOnlineFlag) &&
        Objects.equals(this.sqsDrawOnlineFlag, queryQueueStatusResponse1.sqsDrawOnlineFlag) &&
        Objects.equals(this.sqsOriginAccountOnlineFlag, queryQueueStatusResponse1.sqsOriginAccountOnlineFlag) &&
        Objects.equals(this.trusteeshipFlag, queryQueueStatusResponse1.trusteeshipFlag) &&
        Objects.equals(this.amqQueueOnlineFlag, queryQueueStatusResponse1.amqQueueOnlineFlag) &&
        Objects.equals(this.clientInfo, queryQueueStatusResponse1.clientInfo) &&
        Objects.equals(this.heartBeatDetail, queryQueueStatusResponse1.heartBeatDetail) &&
        Objects.equals(this.taxDiscInfo, queryQueueStatusResponse1.taxDiscInfo) &&
        Objects.equals(this.hasStockInvoiceType, queryQueueStatusResponse1.hasStockInvoiceType) &&
        Objects.equals(this.sourceFrom, queryQueueStatusResponse1.sourceFrom) &&
        Objects.equals(this.refinedOilQualificationFlag, queryQueueStatusResponse1.refinedOilQualificationFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, queueName, priorityQueueName, directOnlineFlag, amqDirectOnlineFlag, sqsDrawOnlineFlag, sqsOriginAccountOnlineFlag, trusteeshipFlag, amqQueueOnlineFlag, clientInfo, heartBeatDetail, taxDiscInfo, hasStockInvoiceType, sourceFrom, refinedOilQualificationFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryQueueStatusResponse1 {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    queueName: ").append(toIndentedString(queueName)).append("\n");
    sb.append("    priorityQueueName: ").append(toIndentedString(priorityQueueName)).append("\n");
    sb.append("    directOnlineFlag: ").append(toIndentedString(directOnlineFlag)).append("\n");
    sb.append("    amqDirectOnlineFlag: ").append(toIndentedString(amqDirectOnlineFlag)).append("\n");
    sb.append("    sqsDrawOnlineFlag: ").append(toIndentedString(sqsDrawOnlineFlag)).append("\n");
    sb.append("    sqsOriginAccountOnlineFlag: ").append(toIndentedString(sqsOriginAccountOnlineFlag)).append("\n");
    sb.append("    trusteeshipFlag: ").append(toIndentedString(trusteeshipFlag)).append("\n");
    sb.append("    amqQueueOnlineFlag: ").append(toIndentedString(amqQueueOnlineFlag)).append("\n");
    sb.append("    clientInfo: ").append(toIndentedString(clientInfo)).append("\n");
    sb.append("    heartBeatDetail: ").append(toIndentedString(heartBeatDetail)).append("\n");
    sb.append("    taxDiscInfo: ").append(toIndentedString(taxDiscInfo)).append("\n");
    sb.append("    hasStockInvoiceType: ").append(toIndentedString(hasStockInvoiceType)).append("\n");
    sb.append("    sourceFrom: ").append(toIndentedString(sourceFrom)).append("\n");
    sb.append("    refinedOilQualificationFlag: ").append(toIndentedString(refinedOilQualificationFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
