package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import com.xforceplus.micro.tax.device.contract.model.SubscribeExtract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SubscribeExtractRequest
 */

@JsonInclude(NON_NULL)
public class SubscribeExtractRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("subscribeExtract")
  private SubscribeExtract subscribeExtract = null;

  @JsonIgnore
  public SubscribeExtractRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public SubscribeExtractRequest subscribeExtract(SubscribeExtract subscribeExtract) {
    this.subscribeExtract = subscribeExtract;
    return this;
  }

   /**
   * 税盘抽取订阅信息
   * @return subscribeExtract
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "税盘抽取订阅信息")
  public SubscribeExtract getSubscribeExtract() {
    return subscribeExtract;
  }

  public void setSubscribeExtract(SubscribeExtract subscribeExtract) {
    this.subscribeExtract = subscribeExtract;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SubscribeExtractRequest subscribeExtractRequest = (SubscribeExtractRequest) o;
    return Objects.equals(this.head, subscribeExtractRequest.head) &&
        Objects.equals(this.subscribeExtract, subscribeExtractRequest.subscribeExtract);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, subscribeExtract);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SubscribeExtractRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    subscribeExtract: ").append(toIndentedString(subscribeExtract)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
