package com.xforceplus.micro.tax.device.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.device.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * TerminalBindClientRequest
 */

@JsonInclude(NON_NULL)
public class TerminalBindClientRequest implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("unionIds")
  private List<String> unionIds = new ArrayList<>();

  @JsonProperty("terminalUns")
  private List<String> terminalUns = new ArrayList<>();

  @JsonIgnore
  public TerminalBindClientRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public TerminalBindClientRequest unionIds(List<String> unionIds) {
    this.unionIds = unionIds;
    return this;
  }

  public TerminalBindClientRequest addUnionIdsItem(String unionIdsItem) {
    this.unionIds.add(unionIdsItem);
    return this;
  }

   /**
   * 终端unionId，一次查询最多支持50个（已废弃，用terminalUns代替）
   * @return unionIds
  **/


  @ApiModelProperty(value = "终端unionId，一次查询最多支持50个（已废弃，用terminalUns代替）")
  public List<String> getUnionIds() {
    return unionIds;
  }

  public void setUnionIds(List<String> unionIds) {
    this.unionIds = unionIds;
  }

  @JsonIgnore
  public TerminalBindClientRequest terminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
    return this;
  }

  public TerminalBindClientRequest addTerminalUnsItem(String terminalUnsItem) {
    this.terminalUns.add(terminalUnsItem);
    return this;
  }

   /**
   * 终端唯一码，一次查询最多支持50个
   * @return terminalUns
  **/


  @ApiModelProperty(value = "终端唯一码，一次查询最多支持50个")
  public List<String> getTerminalUns() {
    return terminalUns;
  }

  public void setTerminalUns(List<String> terminalUns) {
    this.terminalUns = terminalUns;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TerminalBindClientRequest terminalBindClientRequest = (TerminalBindClientRequest) o;
    return Objects.equals(this.head, terminalBindClientRequest.head) &&
        Objects.equals(this.unionIds, terminalBindClientRequest.unionIds) &&
        Objects.equals(this.terminalUns, terminalBindClientRequest.terminalUns);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, unionIds, terminalUns);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TerminalBindClientRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    unionIds: ").append(toIndentedString(unionIds)).append("\n");
    sb.append("    terminalUns: ").append(toIndentedString(terminalUns)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
